% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dengue_MS.R
\docType{data}
\name{dengue_MS}
\alias{dengue_MS}
\title{Dengue cases in \emph{Mato Grosso do Sul}}
\format{
A data frame with 2,640 rows and 27 columns:
\describe{
\item{micro_code}{Unique ID number for each micro region (11 units).}
\item{micro_name}{Name of each micro region.}
\item{micro_name_ibge}{Name of each micro region in IBGE format.}
\item{meso_code}{Unique ID number for each meso region (4 units).}
\item{meso_name}{Name of each meso region.}
\item{state_code}{Unique ID number for each state (1 unit).}
\item{state_name}{Name of each state.}
\item{region_code}{Unique ID number given to each Brazilian Region.
All observations come from the "Southeast Region".}
\item{region_name}{Name of each Brazilian Region.
All observations come from the "Southeast Region".}
\item{biome_code}{Biome code.}
\item{biome_name}{Biome name.}
\item{ecozone_code}{Ecozone code.}
\item{ecozone_name}{Ecozone name.}
\item{main_climate}{Most prevalent climate regime in the microregion.
Based on Koppen Geiger climate regimes.}
\item{month}{Calendar month index, 1 = January, 12 = December.}
\item{year}{Year 2000 - 2019.}
\item{time}{Time index starting at 1 for January 2000.}
\item{dengue_cases}{Number of notified dengue cases registered in the
notifiable diseases system in Brazil (SINAN) in the microregion of
reference, at the month of first symptoms.}
\item{population}{Estimated population based on projections calculated
using the 2000 and 2010 censuses, as well as population counts from 2007
and 2017.}
\item{pop_density}{Population density (number of people per km2).}
\item{tmax}{Monthly average daily maximum temperature; gridded values
(at a 0.5 deg resolution) averaged across each microregion.}
\item{tmin}{Monthly average daily minimum temperature; gridded values
(at a 0.5 deg resolution) averaged across each microregion.}
\item{pdsi}{Self-calibrated Palmer Drought Severity Index for each
microregion. It measures how wet or dry a region is relative to usual
conditions. Negative values represent periods of drought,
positive values represent wetter periods. Calculated by taking the mean
value within each microregion.}
\item{urban}{Percentage of population living in urban areas (2010 census).}
\item{water_network}{Percentage of population with access to the piped
water network according to the 2010 census.}
\item{water_shortage}{Frequency of reported water shortages per microregion
between 2000 and 2016.}
\item{date}{First day of the month in date format ("\%d-\%m-\%Y").}
}
}
\source{
\url{https://github.com/drrachellowe/hydromet_dengue}
}
\usage{
data(dengue_MS)
}
\description{
Monthly number of notified dengue cases by
municipality in the \emph{Mato Grosso do Sul} state of Brazil and a set
of spatial and spatio-temporal covariates.
}
\details{
In addition to the dengue counts, the dataset contains environmental,
socio-economic and meteo-climatic factors. This dataset is a subset of the
original containing observations over the entire Brazil.
}
\keyword{datasets}
