% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Spatialmod_Estimation.R
\name{Sim_Estpar}
\alias{Sim_Estpar}
\title{Calculating the estimated values for the parameters using log-likelihood function}
\usage{
Sim_Estpar(
  Nlabel,
  phi,
  Di,
  alpha1,
  delta,
  lambda1,
  sigma1,
  beta1,
  beta2,
  zz,
  time,
  n,
  tau,
  lambda,
  I,
  D,
  cov1,
  cov2
)
}
\arguments{
\item{Nlabel}{Label for each sample from the area}

\item{phi}{Spatial random effects}

\item{Di}{Euclidean distance between susceptible individual and infectious individual}

\item{alpha1}{intercept}

\item{delta}{Spatial parameter}

\item{lambda1}{Spatial dependence}

\item{sigma1}{precision of spatial random effects}

\item{beta1}{the parameter corresponding to the covariate associated with susceptible individual}

\item{beta2}{the parameter corresponding to the covariate associated with area}

\item{zz}{Number of areas}

\item{time}{Time}

\item{n}{Total number of individuals}

\item{tau}{the set of infectious individuals at time t in the zth area}

\item{lambda}{a vector containing the length of infectious period}

\item{I}{identity matrix}

\item{D}{Neighborhood structure}

\item{cov1}{Individual level covariates}

\item{cov2}{Area level covariates}
}
\value{
a list of the solutions for the estimations of the parameters
}
\description{
Calculating the estimated values for the parameters using log-likelihood function
}
\examples{
Sim_Estpar(rep(1:4,each=5),runif(4,min = 0, max = 1),
matrix(runif(400,min=4,max=20),nrow=20,byrow = TRUE),0.4,3,0.2,0.5,1,1,4,10,
20,sample(c(0,1),replace = TRUE, size = 20),rep(3,20),diag(4),
matrix(c(0,-1,0,-1,-1,0,-1,-1,0,-1,0,-1,-1,-1,-1,0),nrow=4,byrow=TRUE),
runif(20, 0, 1),runif(4, 0, 1))



}
