% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{Get peaks/valleys in waveform data}
\usage{
find_peaks(x, n.points = 3)
}
\arguments{
\item{x}{vector of numbers}

\item{n.points}{the number of decreasing (peaks) or increasing (valleys) data points on left and right of inflection point required to be considered a "peak". A positive number as an input finds peaks, and a negative number finds valleys.}
}
\value{
a numeric vector of indices
}
\description{
`find_peaks` finds peaks or valleys in waveform by using inflection points, with filter of 'n' increasing/decreasing points on both sides of each inflection point.
}
\examples{
### Format data frame
df.new <- format_data(GCaMP)

### How many peaks are there in trial 1 with 10 decreasing data points on each side?
peak.indices <- find_peaks(df.new$Trial1, n.points = 10)

### When do they occur?
data.frame(times = df.new$Time[peak.indices], vals = df.new$Trial1[peak.indices])
}
