% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{varyknotsIC}
\alias{varyknotsIC}
\title{Information criterion for spline regression with a variable number of knots}
\usage{
varyknotsIC(
  knot_bin,
  plen = 0,
  y,
  x,
  x_unique,
  x_base = NULL,
  degree = 3L,
  type = c("ppolys", "ns", "bs"),
  intercept = TRUE,
  ic_method = "BIC"
)
}
\arguments{
\item{knot_bin}{Integer vector (chromosome). Gene 1 stores m, the number of
interior knots. Genes 2:(1+m) are indices into \code{x_unique} selecting the m
interior knots, followed by a sentinel equal to \code{length(x_unique)+1}.
Only genes strictly before the first occurrence of \code{length(x_unique)+1}
are treated as interior indices; genes after the sentinel are ignored. Interior
indices must be in \code{2:(length(x_unique)-1)}, finite, and non-duplicated.}

\item{plen}{Unused placeholder kept for API compatibility; ignored.}

\item{y}{Numeric response vector of length \eqn{n}.}

\item{x}{Numeric predictor (same length as \code{y}) on which the spline
basis is constructed.}

\item{x_unique}{Optional numeric vector of unique candidate knot locations.
If missing or \code{NULL}, defaults to \code{sort(unique(x))}. Must have
at least three values (two boundaries + one interior) to allow any knots.}

\item{x_base}{Optional matrix (or vector) of additional covariates to include
linearly alongside the spline basis; coerced to a matrix if supplied.}

\item{degree}{Integer polynomial degree for \code{type="ppolys"} and
\code{type="bs"} (default \code{3L}). Ignored for \code{type="ns"} (always cubic).}

\item{type}{One of \code{c("ppolys","ns","bs")}; forwarded to [splineX()].}

\item{intercept}{Logical; forwarded to [splineX()]. For \eqn{m>0}, the spline
block is \code{splineX(..., intercept=intercept)} and \emph{no explicit 1-column}
is added here; for \eqn{m=0}, an explicit intercept is added via
\code{cbind(1, x_base)}. Set \code{intercept=FALSE} if you plan to add your own 1-column.}

\item{ic_method}{Which information criterion to return: \code{"BIC"},
\code{"AIC"}, or \code{"AICc"}.}
}
\value{
A single numeric value: the requested information criterion (lower is
  better). Returns \code{Inf} for invalid chromosomes/inputs.
}
\description{
Evaluates an information criterion (BIC, AIC, or AICc) for a regression of
\code{y} on a spline basis of \code{x} where the number and locations of
interior knots are encoded in the chromosome. Designed for use as a GA
objective/fitness function. The spline basis is constructed via [splineX()].
}
\details{
If \eqn{m = 0}, the model is a pure-linear baseline using only an intercept
and \code{x_base}: \code{X <- cbind(1, x_base)} (no spline terms).
For \eqn{m > 0}, the spline block is built with [splineX()] using the selected
interior knots, with \code{X <- cbind(splineX(..., intercept=intercept), x_base)}.

The criteria are computed as:
\deqn{\mathrm{BIC} = n \log(\mathrm{SSRes}/n) + p \log n,}
\deqn{\mathrm{AIC} = n \log(\mathrm{SSRes}/n) + 2p,}
\deqn{\mathrm{AICc} = n \log(\mathrm{SSRes}/n) + 2p +
      \frac{2p(p+1)}{n-p-1},}
where \eqn{\mathrm{SSRes}} is the residual sum of squares and \eqn{p} is the
number of columns in the design matrix \code{X}.
}
\note{
This function allows \eqn{m=0} (no spline terms) so that the GA can
  compare against a pure-linear baseline (intercept + \code{x_base}).
  Spacing constraints (e.g., minimum distance between indices) should be
  enforced by the GA operators or an external penalty.
}
\examples{
## Example with 'mcycle' data (MASS)
# y <- mcycle$accel; x <- mcycle$times
# x_unique <- sort(unique(x))
# chrom <- c(5, 24, 30, 46, 49, 69, length(x_unique) + 1)
# varyknotsIC(chrom, y=y, x=x, x_unique=x_unique,
#             type="ppolys", degree=3, ic_method="BIC")
}
\seealso{
[fixknotsIC()], [splineX()], \code{\link[splines]{bs}}, \code{\link[splines]{ns}}
}
