% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{fixknotsIC}
\alias{fixknotsIC}
\title{Information criterion for a fixed–knot spline regression}
\usage{
fixknotsIC(
  knot_bin,
  plen = 0,
  y,
  x,
  x_unique,
  x_base = NULL,
  fixedknots,
  degree = 3L,
  type = c("ppolys", "ns", "bs"),
  intercept = TRUE,
  ic_method = "BIC"
)
}
\arguments{
\item{knot_bin}{Integer vector (chromosome). Gene 1 stores m, the number of
interior knots. Genes 2:(1+m) are indices into \code{x_unique} selecting the m
interior knots, followed by a sentinel equal to \code{length(x_unique)+1}.
Only genes strictly before the first occurrence of \code{length(x_unique)+1}
are treated as interior indices; genes after the sentinel are ignored. Interior
indices must be in \code{2:(length(x_unique)-1)}, finite, and non-duplicated.}

\item{plen}{Unused placeholder kept for API compatibility with other
objective functions. Ignored.}

\item{y}{Numeric response vector of length \eqn{n}.}

\item{x}{Numeric predictor (same length as \code{y}) on which the spline
basis is built.}

\item{x_unique}{Optional numeric vector of unique candidate knot locations.
If \code{NULL} or missing, it defaults to \code{sort(unique(x))}. Must
contain at least \eqn{m + 2} values (interior + two boundaries).}

\item{x_base}{Optional matrix (or vector) of additional covariates to include
linearly alongside the spline basis. If supplied, it is coerced to a matrix
and column-bound to the design.}

\item{fixedknots}{Integer \eqn{m}: the number of interior knots to use.
Internally this determines how many indices are read from \code{knot_bin}.}

\item{degree}{Integer polynomial degree for \code{type="ppolys"} and
\code{type="bs"} (default \code{3L}). Ignored for \code{type="ns"} (cubic).}

\item{type}{One of \code{c("ppolys","ns","bs")}; forwarded to [splineX()].}

\item{intercept}{Logical; forwarded to [splineX()]. For \eqn{m>0}, the spline
block is \code{splineX(..., intercept=intercept)} and no explicit 1-column is
added here. If you add your own intercept in \code{X}, call
\code{splineX(..., intercept=FALSE)}.}

\item{ic_method}{Character; which information criterion to return:
\code{"BIC"}, \code{"AIC"}, or \code{"AICc"}.}
}
\value{
A single numeric value: the requested information criterion. Lower is
  better. Returns \code{Inf} for invalid chromosomes/inputs.
}
\description{
Computes an information criterion (BIC, AIC, or AICc) for a regression of
\code{y} on a spline basis of \code{x} when the number of interior knots is
fixed. This is designed to be used as a fitness/objective function inside a
GA search where the chromosome encodes the indices of the interior knots.
}
\details{
We decode the interior indices up to the sentinel \code{length(x_unique)+1},
validate them (finite, interior, non-duplicated), sort the resulting knot
locations internally, and build the design as
\code{X <- cbind(splineX(..., intercept=intercept), x_base)}.
Invalid chromosomes/inputs return \code{Inf}.
}
\examples{
library(MASS)
y <- mcycle$accel
x <- mcycle$times
x_unique <- sort(unique(x))
# chromosome encoding 5 interior knot indices with sentinel:
chrom <- c(5, 24, 30, 46, 49, 69, length(x_unique) + 1)
fixknotsIC(chrom,
  y = y, x = x, x_unique = x_unique,
  fixedknots = 5, ic_method = "BIC"
)
}
\seealso{
[varyknotsIC()], [splineX()], \code{\link[splines]{bs}}, \code{\link[splines]{ns}}
}
