#' Network Embedding using biased random walk and Word2Vec.
#' 
#' @param net_list A list containing data frames that can be coerced into pandas data frames. Each data frame contains 3 columns, source, target and weight, representing the connections between nodes in the networks.
#' @param p A parameter for the BiasedRandomWalk.Defines probability, 1/p, of returning to source node.
#' @param q A parameter for the BiasedRandomWalk.Defines probability, 1/q, for moving to a node away from the source node.
#' @param num A parameter for the BiasedRandomWalk. Defines the number of walks per node.
#' @param l A parameter for the BiasedRandomWalk. Defines the length of each walk.
#' @param vector_size The size of the Word2Vec vectors.
#' @param window The window size for the Word2Vec model.
#' @param min_count Minimum count for the Word2Vec model.
#' @param sg_model Training algorithm for Word2Vec (0 for CBOW, 1 for skip-gram).
#' @param workers Number of worker threads to train the Word2Vec model.
#' @param epochs Number of epochs to train the Word2Vec model.
#' @details This function performs a network embedding using the python libraries stellargraph and gensim through the BiasedRandomWalk and Word2Vec functions, respectively. 
#' @return A list of data frames with node embeddings. Each data frame contains nxm dimensions, where n is the number of unique nodes in the network and m is the number of reduced dimensions defined in the function.
#' @name Net_embedding
#' @export

Net_embedding <- function(net_list,p = 0.25, q = 1, num = 10, l = 80,vector_size=32, window=10, min_count=1, sg_model=1, workers=4, epochs=20){

reticulate::source_python(system.file("python/net_embedding_R.py", package = "GALLO"))
  
net_embedding(net_list,p = p, q = q, num = num, l = l,vector_size=vector_size, window=window, min_count=min_count, sg_model=sg_model, workers=workers, epochs=epochs)
  
}