% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotData.R
\name{ggplot_fp}
\alias{ggplot_fp}
\title{Internal ggplot Wrapper to Graph Frequency Profiles}
\usage{
ggplot_fp(data1, resolution = resolution, step = step, yAxis = yAxis,
  xAxisUnits = xAxisUnits, xmin = xmin, xmax = xmax,
  tick.every = tick.every, label.every = label.every)
}
\arguments{
\item{data1}{data formated into \code{freqprof} class.}

\item{resolution}{resolution of \code{freqprof} data}

\item{step}{step size of \code{freqprof} data}

\item{yAxis}{a string providing a label for the y-axis.}

\item{xAxisUnits}{a string indicating which unit has been used. By default, 
"sec".}

\item{xmin}{x-axis minimum value}

\item{xmax}{x-axis maximum value}

\item{tick.every}{the spacing between each tick. By default, N/30 where N is 
the number of time units.}

\item{label.every}{label every X ticks, where X = label.every. By default, 
label.every = 3.}
}
\value{
A ggplot of the frequency profile data in \code{data1}
}
\description{
Internal ggplot Wrapper to Graph Frequency Profiles
}

