% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_llh_rcpp.R
\name{log_llh_rcpp}
\alias{log_llh_rcpp}
\title{Log-likelihood computation in RCPP}
\usage{
log_llh_rcpp(
  param,
  nb.e.a,
  nb.priorMean.beta,
  nb.alpha,
  competing_risk,
  nb.alpha.CR,
  variability_hetero,
  S,
  Zq,
  sharedtype,
  sharedtype_CR,
  hazard_baseline,
  hazard_baseline_CR,
  ord.splines,
  Xtime,
  Utime,
  nb_pointsGK,
  Xs,
  Us,
  Xslope,
  Uslope,
  Xs.slope,
  Us.slope,
  indices_beta_slope,
  Time,
  st_calc,
  B,
  Bs,
  wk,
  Z,
  P,
  left_trunc,
  Z_CR,
  X_base,
  offset,
  U,
  y.new.prog,
  event1,
  event2,
  Ind,
  Xs.0,
  Us.0,
  Xs.slope.0,
  Us.slope.0,
  P.0,
  st.0,
  Bs.0,
  B.CR,
  Bs.CR,
  Bs.0.CR,
  nb.e.a.sigma = nb.e.a.sigma,
  nb.omega = nb.omega,
  Otime = Otime,
  Wtime = Wtime,
  Os = Os,
  Ws = Ws,
  O_base = O_base,
  W_base = W_base,
  correlated_re = correlated_re,
  Os.0 = Os.0,
  Ws.0 = Ws.0
)
}
\arguments{
\item{param}{a vector : paramaters to be estimated}

\item{nb.e.a}{integer : number of RE}

\item{nb.priorMean.beta}{integer : number of fixed effects}

\item{nb.alpha}{integer : number of covariates in survival model}

\item{competing_risk}{boolean : allow competing risk or not, FALSE by default}

\item{nb.alpha.CR}{integer : number of covariates in survival model for competing risks}

\item{variability_hetero}{boolean : allow the heterogeneous variability or not}

\item{S}{integer : the number of QMC points}

\item{Zq}{vector : sobol points}

\item{sharedtype}{vector : dependence structure for survival model : "RE" (random effects) or "CV" (current value) or "CVS" (current value and slope) or "S" (slope)}

\item{sharedtype_CR}{vector : dependence structure for competing risk survival model : "RE" (random effects) or "CV" (current value) or "CVS" (current value and slope) or "S" (slope)}

\item{hazard_baseline}{char : baseline hazard function : "Exponential" or "Weibull" or "Splines"}

\item{hazard_baseline_CR}{char : baseline hazard function, competing risk : "Exponential" or "Weibull" or "Splines"}

\item{ord.splines}{integer : the order of splines function for baseline hazard function}

\item{Xtime}{matrix : fixed effects at event time}

\item{Utime}{matrix : RE at event time}

\item{nb_pointsGK}{integer : number of points for Gauss-Kronrod approximation, 7 or 15 (default)}

\item{Xs}{matrix : fixed effects at Gauss-Kronrod times}

\item{Us}{matrix : RE at Gauss-Kronrod times}

\item{Xslope}{matrix : fixed effects of slope at event times}

\item{Uslope}{matrix : RE of slope at event times}

\item{Xs.slope}{matrix : fixed effects of slope at Gauss-Kronrod times}

\item{Us.slope}{matrix : RE of slope at Gauss-Kronrod times}

\item{indices_beta_slope}{vector : position of beta which will be used in the slope computation}

\item{Time}{vector : observed event times}

\item{st_calc}{matrix : Gauss-Kronrod times}

\item{B}{matrix : splines for baseline hazard function of event 1}

\item{Bs}{matrix : splines for baseline survival function of event 1}

\item{wk}{vector : Gauss-Kronrod weights}

\item{Z}{matrix : covariates for survival function of event 1}

\item{P}{vector : Time/2}

\item{left_trunc}{boolean : left truncation indicator}

\item{Z_CR}{matrix : covariates for survival function of event 2}

\item{X_base}{matrix : fixed effects for longitudinal submodel}

\item{offset}{vector : number of lines per subjects}

\item{U}{matrix : RE for longitudinal submodel}

\item{y.new.prog}{vector : y measures for longitudinal submodel}

\item{event1}{vector : event 1 indicator}

\item{event2}{vector : event 2 indicator}

\item{Ind}{integer : number of subjects}

\item{Xs.0}{same for left truncation}

\item{Us.0}{same for left truncation}

\item{Xs.slope.0}{same for left truncation}

\item{Us.slope.0}{same for left truncation}

\item{P.0}{same for left truncation}

\item{st.0}{same for left truncation}

\item{Bs.0}{same for left truncation}

\item{B.CR}{same for left truncation}

\item{Bs.CR}{same for left truncation}

\item{Bs.0.CR}{same for left truncation}

\item{nb.e.a.sigma}{integer : number of RE for variability}

\item{nb.omega}{integer : number of fixed effects for variability}

\item{Otime}{matrix : fixed effects of variability at event time}

\item{Wtime}{matrix : RE of variability at event time}

\item{Os}{matrix : fixed effects of variability at Gauss-Kronrod times}

\item{Ws}{matrix : random effects of variability at Gauss-Kronrod times}

\item{O_base}{matrix : fixed effects for variability}

\item{W_base}{matrix : fixed effects for variability}

\item{correlated_re}{boolean : indicator to allow all the random effects to be correlated}

\item{Os.0}{matrix : same for left truncation}

\item{Ws.0}{matrix : same for left truncation}
}
\value{
The value of the log-likelihood
}
\description{
Log-likelihood computation in RCPP
}
