% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaBin_functions.R
\name{dBetaBin}
\alias{dBetaBin}
\alias{qBetaBin}
\alias{pBetaBin}
\alias{rBetaBin}
\title{The Beta-Binomial Distribution}
\usage{
dBetaBin(x, size, mu, theta = NULL, phi = NULL, log = FALSE)

qBetaBin(prob, size, mu, theta = NULL, phi = NULL, log.prob = FALSE)

pBetaBin(q, size, mu, theta = NULL, phi = NULL, log.prob = FALSE)

rBetaBin(n, size = NULL, mu = NULL, theta = NULL, phi = NULL)
}
\arguments{
\item{x, q}{a vector of quantiles.}

\item{size}{the total number of trials.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{theta}{the overdispersion parameter. It must  lie in (0, 1).}

\item{phi}{the precision parameter, an alternative way to specify the overdispersion parameter \code{theta}. It must be a real positive value.}

\item{log}{logical; if TRUE, probabilities are returned on log-scale.}

\item{prob}{a vector of probabilities.}

\item{log.prob}{logical; if TRUE, probabilities \code{prob} are given as log(prob).}

\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
The function \code{dBetaBin} returns a vector with the same length as \code{x} containing the probability mass values.
The function \code{pBetaBin} returns a vector with the same length as \code{q} containing the values of the distribution function.
The function \code{qBetaBin} returns a vector with the same length as \code{prob} containing the quantiles.
The function \code{rBetaBin} returns a vector of length \code{n} containing the generated random values.
}
\description{
Mass function, distribution function, quantile function, and random generation
for the beta-binomial distribution.
}
\details{
The beta-binomial distribution has probability mass function
\deqn{f_{BB}(x;\mu,\phi)={n\choose x} \frac{\Gamma{(\phi)}}{\Gamma{(\mu\phi)}\Gamma{((1-\mu)\phi)}} \frac{\Gamma{(\mu\phi+x)}\Gamma{((1-\mu)\phi + n - x)}}{\Gamma{(\phi + n)}},}
for \eqn{x \in \lbrace 0, 1, \dots, n \rbrace}, where \eqn{0<\mu<1} identifies the mean and \eqn{\phi=(1-\theta)/\theta >0} is the precision parameter.
}
\examples{
dBetaBin(x = 5, size = 10, mu = .3, phi = 10)
dBetaBin(x = 5, size = 10, mu = .3, theta = 1/(10+1))

qBetaBin(prob = .5, size = 10, mu = .3, phi = 10)
qBetaBin(prob = .5, size = 10, mu = .3, theta = 1/(10+1))

pBetaBin(q = 5, size = 10, mu = .3, phi = 10)
pBetaBin(q = 5, size = 10, mu = .3, theta = 1/(10+1))

rBetaBin(n = 100, size = 40, mu = .5, theta = .4)
rBetaBin(n = 100, size = 40, mu = .5, phi = 1.5)

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005
}
}
