% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tapering.R
\name{tapering}
\alias{tapering}
\title{Tapering Opreator on Covariance Matrix}
\usage{
tapering(sigma, l, h = 1/2)
}
\arguments{
\item{sigma}{a p*p covariance matrix}

\item{l}{tapering parameter}

\item{h}{the ratio between taper l_h and parameter l}
}
\value{
a regularized covariance matrix after tapering operation
}
\description{
Apply tapering operator on a covariance matrix with tapering parameters.
}
\examples{
data(m.excess.c10sp9003)
cov.SAM <- cov(m.excess.c10sp9003)
tapering(cov.SAM, l=7, h = 1/2)
}
\references{
"High-Dimensional Covariance Estimation" by Mohsen Pourahmadi
}

