% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{stopp}
\alias{stopp}
\title{Custom Stop Function Without Call}
\usage{
stopp(..., domain = NULL)
}
\arguments{
\item{...}{Arguments passed on to \code{stop}.}

\item{domain}{The translation domain, NULL by default.}
}
\value{
No return value, this function stops execution of the program.
}
\description{
This function provides a wrapper around the base \code{\link[=stop]{stop()}} function,
but it automatically sets \code{call.} to FALSE, which means the function
call itself is not included in the resulting error message. This makes error
messages cleaner.
The \code{domain} argument can be used to specify a translation domain.
}
\examples{
\donttest{
try(stopp("This is a custom stop message without the call."), silent = TRUE)
}
}
\seealso{
\code{\link[=stop]{stop()}}
}
\keyword{validation}
