% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{getPlotDims}
\alias{getPlotDims}
\title{Get the dimensions of a ggplot Object}
\usage{
getPlotDims(plt)
}
\arguments{
\item{plt}{A ggplot object.}
}
\value{
A list with elements \code{xr} (a vector of xmin and xmax) and \code{yr} (a
vector of ymin and ymax).
}
\description{
This function retrieves the minimum and maximum x and y dimensions of a
ggplot object. Note that it is the dimension of the plot within the x and y
axis and not the dimensions of the actual output image itself. This may be
useful for numerical computations when modifying plots, but can be slow since
it builds the actual plot first.
}
\examples{
library(ggplot2)
getPlotDims(ggplot(mtcars) + geom_point(aes(mpg, cyl)))

}
\keyword{ggplot}
