% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{getFailStr}
\alias{getFailStr}
\title{Get Failure Message as a character}
\usage{
getFailStr(cond)
}
\arguments{
\item{cond}{A condition object representing an error or warning - probably
from a \code{\link[=tryCatch]{tryCatch()}} statement.}
}
\value{
A character string containing the failure message.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function generates a failure message string from a given condition.
The message includes the context of the call and the specific condition
message.
}
\examples{
tryCatch(stop("Example error"), error = function(e) getFailStr(e))
}
\keyword{validation}
