context("FastImputation")

good_df <- data.frame(X1=letters, 
                      X2=1:26, 
                      X3=rnorm(26), 
                      X4=rexp(26), 
                      X5=runif(26), 
                      X6=sample(c(TRUE, FALSE), 26, replace=TRUE),
                      X7=3 - rexp(26),
                      X8=rnorm(26), 
                      X9=rnorm(26), 
                      X10=rnorm(26), 
                      X11=rnorm(26))
good_constraints <- list(list("X7", list(upper=3)),
                         list("X4", list(lower=0)),
                         list("X5", list(lower=0, upper=1)))
good_ignore <- c("X2", "X1")
good_categorical <- c("X6")

good_patterns <- TrainFastImputation(good_df, 
                                     constraints=good_constraints,
                                     idvars=good_ignore,
                                     categorical=good_categorical)

good_test_set <- data.frame(X1=c("XX", "DD"),
                            X2=5:6,
                            X3=c(NA,1),
                            X4=1:2,
                            X5=c(.25, .75),
                            X6=c(TRUE, NA),
                            X7=1:2,
                            X8=rnorm(2),
                            X9=rnorm(2),
                            X10=rnorm(2),
                            X11=rnorm(2))

good_imputed_set <- FastImputation(good_test_set, patterns=good_patterns, verbose=FALSE)

bad_df <- data.frame(X3=rnorm(5), 
                     X6=sample(c(TRUE, FALSE), 5, replace=TRUE))
bad_array <- matrix(1:9, nrow=3)

test_that("FastImputation catches bad input", {
  expect_error(FastImputation(good_test_set, verbose=FALSE), 
               "A 'patterns' object generated by 'TrainFastImputation' must be specified.")
  expect_error(FastImputation(good_test_set, patterns=5, verbose=FALSE), 
               "'patterns' must be of class 'FastImputationPatterns'. This is generated by appropriate use of the 'TrainFastImputation' function.")
  expect_error(FastImputation(bad_array, patterns=good_patterns, verbose=FALSE), 
               "'x' must be a dataframe.")
  expect_error(FastImputation(bad_df, patterns=good_patterns, verbose=FALSE), 
               "The names of the variables you are imputing don't match those of the training data. Check to make sure the data is in the same format with the same columns in the same order.")
})

test_that("FastImputation returns correct types", {
  expect_true( is.data.frame(good_imputed_set) )
})

test_that("FastImputation returns correct values", {
  compare( good_imputed_set$X3[1], -.4076268, tolerance=.01 )
  compare( good_imputed_set$X6[2], TRUE )
})
