% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictivestructure.R
\name{predictive.struct}
\alias{predictive.struct}
\title{Use the predictive structure of the FVDDP to sequentially draw values adn update}
\usage{
predictive.struct(fvddp, N)
}
\arguments{
\item{fvddp}{The instance of class \code{fvddp} the values are drawn from.}

\item{N}{The amount of values to draw.}
}
\value{
A vector of length \code{N} of values obtained using the predictive structure.
Precisely, after that any observation is drawn (either from the centering measure
or from past observations) the input \code{fvddp} is modified as if the function
\code{\link[=update]{update()}} is called, with the new value as second argument.
}
\description{
Use the predictive structure of the FVDDP to sequentially draw values adn update
}
\examples{
#create a dumy process and expoit the predictive structure
FVDDP = initialize(7, function(x) rbeta(x, 3,3),
                   function(x) dgamma(x, 3,3), FALSE)
FVDDP = update(FVDDP, rep(0:1, 2))
predictive.struct(fvddp = FVDDP, N = 100)

}
\references{
{
\insertRef{AscolaniLijoiRuggiero2021}{FVDDPpkg}
}
}
