% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlagOneEdge.R
\name{FlagOneEdge}
\alias{FlagOneEdge}
\title{Use FLAG to infer one edge. Given n*p data matrix, when we only interest in the conditional dependence between i-th and j-th variables.}
\usage{
FlagOneEdge(data, i, j, scale.var = TRUE, infer = "llr", eps = 1e-07)
}
\arguments{
\item{data}{Matrix, with size n*p.}

\item{i}{integer, the index of one element.}

\item{j}{integer, the index of another element.}

\item{scale.var}{Logical, whether to scale the variance of X to 1/p, default to be T(RUE).}

\item{infer}{Character, option of different tests of inference where 'llr' for likelihood ratio test and 'wald' for Wald test based on Fisher Information Matrix.}

\item{eps}{Numeric, a small term to avoid numerical problems, default to be 1e-7.}
}
\value{
List,
the list of log likelihood during iterations,
the estimated precision value,
the p-value of precision value estimation,
the estimated Gamma_beta matrix with size 2\emph{2, in the random effects model,
the estimated Gamma_epsilon matrix with size 2}2, in the random effects model,
the estimated off-diagonal element eta in the matrix Gamma_epsilon,
the standard error of eta,
the estimated partial correlation rho,
the standard error of rho,
the p-value of rho,
the execution time.
}
\description{
Use FLAG to infer one edge. Given n*p data matrix, when we only interest in the conditional dependence between i-th and j-th variables.
}
\examples{
\donttest{
FlagOneEdge(matrix, i, j)
}
}
