% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filest.R
\name{filest}
\alias{filest}
\title{Simulate data for multiple populations}
\usage{
filest(setting, out, thread = 1)
}
\arguments{
\item{setting}{An absolute path to a setting file}

\item{out}{An absolute path for output files}

\item{thread}{A number to specify a maximum thread to be run in parallel}
}
\value{
NULL if done successfully. NA if output directory can't be created.
}
\description{
The output files are saved to the specified directory according to \code{out}.
}
\details{
This function takes the specific input file containing the settings
for simulations. It allows multiple settings for several simulation within
one file. The simulation-setting file must be a text file. The line started
with "--" indicates the parameters for simulation, and the line started with
"#" are comments. Empty lines are allowed in the setting file. The parameters
in the setting file are listed below:
\itemize{
\item \code{--setting}	A name of setting
\item \code{--population} A list that indicates the numbers of population
separated by comma
\item \code{--fst}	A list that indicates the Fst values separated by comma.
Each Fst value represents a genetic distance of that particular population
and the first population. The Fst values for the first population and the
second population should be the same values, otherwise they will be summed up
and devided by two.
\item \code{--case} A list that indicates the ratio values of cases separated
by comma
\item \code{--outlier}	A list that indicates the logical values (0/1) whether
that population are outliers, separated by comma
\item \code{--marker} A number of SNPs
\item \code{--replicate}	A number of replicates
\item \code{--riskratio} A number of replicates
\item \code{--no.case.snp}	A number of case SNPs
\item \code{--pc} A logical value (TRUE/FALSE) whether PCs will be calculated.
\item \code{--fulloutput} A logical value (TRUE/FALSE) whether all
information will be exported.
}
}
\examples{

#Check and run the demo from demo.filest()
demo.filest()

#Here is the code for demo.filest()
txt <- "--setting=example1\n"
txt <- paste0(txt, "--population=100,100\n")
txt <- paste0(txt, "--fst=0.01,0.01\n")
txt <- paste0(txt, "--case=0,0\n")
txt <- paste0(txt, "--outlier=0,0\n")
txt <- paste0(txt, "--marker=1000\n")
txt <- paste0(txt, "--replicate=1\n")
txt <- paste0(txt, "--riskratio=1\n")
txt <- paste0(txt, "--no.case.snp=0\n")
txt <- paste0(txt, "--pc=TRUE\n")
txt <- paste0(txt, "--missing=0\n")
txt <- paste0(txt, "--fulloutput=TRUE\n")

outdir <- file.path(tempdir())

settingfile <- file.path(outdir, "example1.txt")
fo <- file(settingfile,"w")
for (i in txt){ write(i,fo)}
close(fo)

filest(setting = settingfile, out = outdir, thread = 1)

}
