% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_threshold_numeric_grid.R
\name{fftrees_threshold_numeric_grid}
\alias{fftrees_threshold_numeric_grid}
\title{Perform a grid search over thresholds and return accuracy statistics for a given numeric cue}
\usage{
fftrees_threshold_numeric_grid(
  thresholds,
  cue_v,
  criterion_v,
  directions = c(">", "<="),
  goal.threshold = NULL,
  sens.w = NULL,
  my.goal = NULL,
  my.goal.fun = NULL,
  cost.each = NULL,
  cost.outcomes = NULL
)
}
\arguments{
\item{thresholds}{numeric. A vector of thresholds to consider.}

\item{cue_v}{numeric. Feature values.}

\item{criterion_v}{logical. A logical vector of (TRUE) criterion values.}

\item{directions}{character. Possible directions to consider.}

\item{goal.threshold}{A character string indicating the criterion to maximize when \emph{optimizing cue thresholds}:
\code{"acc"} = overall accuracy, \code{"bacc"} = balanced accuracy, \code{"wacc"} = weighted accuracy,
\code{"dprime"} = discriminability, \code{"cost"} = costs (based only on \code{cost.outcomes}, as \code{cost.cues} are constant per cue).
Default: \code{goal.threshold = "bacc"}.}

\item{sens.w}{numeric. Sensitivity weight parameter (from \code{0} to \code{1}, for computing \code{wacc}).
Default: \code{sens.w = .50}.}

\item{my.goal}{Name of an optional, user-defined goal (as character string). Default: \code{my.goal = NULL}.}

\item{my.goal.fun}{User-defined goal function (with 4 arguments \code{hi fa mi cr}). Default: \code{my.goal.fun = NULL}.}

\item{cost.each}{numeric. A constant cost value to add to each value (e.g., the cost of the cue).}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying
the costs of a hit, false alarm, miss, and correct rejection, respectively, in some common currency.
For instance, \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that
a false alarm and miss cost \code{10} and \code{20} units, respectively, while correct decisions have no cost.}
}
\value{
A data frame containing accuracy statistics for numeric thresholds.
}
\description{
Perform a grid search over thresholds and return accuracy statistics for a given numeric cue
}
\seealso{
\code{\link{fftrees_threshold_factor_grid}} for factor cues.
}
