% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{SolRad}
\alias{SolRad}
\title{Solar Radiation (R_s)}
\usage{
SolRad(
  n = NULL,
  N = NULL,
  a_s = 0.25,
  b_s = 0.5,
  R_a,
  T_max = NULL,
  T_min = NULL,
  region = NULL
)
}
\arguments{
\item{n}{Optional. A numeric scalar that denotes actual duration of sunshine [hour]}

\item{N}{Optional. A numeric scalar that denotes maximum possible duration of sunshine or daylight hours [hour]}

\item{a_s}{Optional. A numeric scalar that denotes regression constant, expressing the fraction ofextraterrestrial radiation
reaching the earth on overcast days (n = 0). The default is \code{a_s = 0.25}.}

\item{b_s}{Optional. A numeric scalar that denotes fraction of extraterrestrial radiation reaching the earth on clear days
(\eqn{n = N}). The default is \code{b_s = 0.5}}

\item{R_a}{A numeric scalar that denotes extraterrestrial radiation [\eqn{MJ/(m^2\times day)}]}

\item{T_max}{Optional. A numeric scalar that denotes the daily maximum temperature [C].}

\item{T_min}{Optional. A numeric scalar that denotes the daily minimum temperature [C].}

\item{region}{A character string that introduce the type of region and can be assigned "inter" for interior locations
and "coast" for coastal locations for Hargreaves radiation formula (alternative)}
}
\value{
The function returns the value of solar radiation based as a numeric scalar.
}
\description{
\code{SolRad} returns the value of solar radiation.
}
\details{
This is a function to calculate the solar radiation based on the land type. If one of the arguments \code{n} or \code{N}
   is missing, the function needs to use the values of the arguments \code{T_min}, \code{T_max}, and \code{region}.
   If calibrated values of \code{a_s} and \code{b_s} are available, they can replace the default values.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
SolRad(n = 7.1, N = 10.9, R_a = 25.1)
SolRad(R_a = 25.1, T_max = 30, T_min = 20, region = "inter")

}
\seealso{
\code{\link{ExRad}}.
}
