% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{NSRad}
\alias{NSRad}
\title{Net Shortwave Radiation (R_ns)}
\usage{
NSRad(R_s)
}
\arguments{
\item{R_s}{A numeric scalar that denotes the incoming solar radiation [\eqn{MJ/(m^2\times day)}].}
}
\value{
The function returns the value of net shortwave radiation as a numeric scalar.
}
\description{
\code{NSRad} returns the value of net shortwave radiation.
}
\details{
This is a function to calculate the net shortwave radiation.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
NSRad(R_s = 14.5)

}
\seealso{
\code{\link{SolRad}, \link{NLRad}, \link{NRad}}.
}
