% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanET.R
\name{MeanRH}
\alias{MeanRH}
\title{Mean Relative Humidity (RH_mean)}
\usage{
MeanRH(T_min, T_max)
}
\arguments{
\item{T_min}{Optional. A numeric scalar that denotes the daily minimum temperature [C].}

\item{T_max}{Optional. A numeric scalar that denotes the daily maximum temperature [C].}
}
\value{
The function returns the value of the mean relative humidity as a numeric scalar.
}
\description{
\code{MeanRH} returns the value of mean relative humidity.
}
\details{
This is a function to calculate the mean relative humidity.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
MeanRH(T_min = 19, T_max = 26)

}
\seealso{
\code{\link{SatVP}}.
}
