% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HrgETo.R
\name{ETo_Hrg}
\alias{ETo_Hrg}
\title{Hargreaves Reference Evapotranspiration (ETo) Equation}
\usage{
ETo_Hrg(T_min, T_max, R_a)
}
\arguments{
\item{T_min}{Optional. A numeric scalar that denotes the daily minimum temperature [C].}

\item{T_max}{Optional. A numeric scalar that denotes the daily maximum temperature [C].}

\item{R_a}{A numeric scalar denotes the extraterrestrial radiation [\eqn{MJ/(m^2\times day)}].}
}
\value{
The function returns the value of evapotranspiration rate from the reference surface calculated by
Hargreaves equation [mm/day] as a numeric scalar.
}
\description{
\code{ETo_Hrg} returns the value of the evapotranspiration rate from the reference surface.
}
\details{
This is a function to calculate the evapotranspiration rate from the reference surface (ETo)
by using Hargreaves equation.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
ETo_Hrg(T_min = 19, T_max = 25, R_a = 32)

}
\seealso{
\code{\link{ETo_FPM}} for FAO Penman-Monteith Equation.
}
