% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEzGP_predict.R
\name{EEzGP_predict}
\alias{EEzGP_predict}
\title{The Prediction Function of \code{EEzGP} Model}
\usage{
EEzGP_predict(X_new, model, MSE_on = 0)
}
\arguments{
\item{X_new}{Matrix or vector containing the input(s) where the predictions are to be made. Each row is an input vector.}

\item{model}{The EEzGP model fitted by \code{\link[EzGP]{EEzGP_fit}}.}

\item{MSE_on}{A scalar indicating whether the uncertainty (i.e., mean squared error \code{MSE}) is calculated. Set to a non-zero value to calculate \code{MSE}.}
}
\value{
A prediction list containing the following components:
\itemize{
\item{\code{Y_hat}} {A vector containing the prediction values}
\item{\code{MSE}} {A vector containing the prediction uncertainty (i.e., the covariance or covariance matrix for the output(s) at prediction location(s)) }
}
}
\description{
Predicts the output of the EEzGP model fitted by \code{\link[EzGP]{EEzGP_fit}}.
}
\examples{
# This function is used in a similar way as the use of EzGP_predict.
# See the examples in the documentation of the function EEzGP_fit.
}
\references{
\enumerate{
\item "EzGP: Easy-to-Interpret Gaussian Process Models for Computer Experiments with Both Quantitative and Qualitative Factors", Qian Xiao, Abhyuday Mandal, C. Devon Lin, and Xinwei Deng (\doi{10.1137/19M1288462})
}
}
\seealso{
\code{\link[EzGP]{EEzGP_fit}} to fit EEzGP model for the datasets.\cr
}
