% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latsd.R
\name{latsd}
\alias{latsd}
\title{Latin Square Design}
\usage{
latsd(
  treat,
  row,
  column,
  resp,
  quali = TRUE,
  mcomp = "tukey",
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{treat}{Numeric or complex vector containing the
treatments.}

\item{row}{Numeric or complex vector containing the rows.}

\item{column}{Numeric or complex vector containing the
columns.}

\item{resp}{Numeric or complex vector containing the
response variable.}

\item{quali}{Logic. If TRUE (default), the treatments are
assumed qualitative, if FALSE, quantitatives.}

\item{mcomp}{Allows choosing the multiple comparison test;
the \emph{default} is the test of Tukey, however, the
options are: the LSD test ('lsd'), the LSD test with
Bonferroni protection ('lsdb'), the test of Duncan
('duncan'), the test of Student-Newman-Keuls ('snk'), the
test of Scott-Knott ('sk'), the Calinski and Corsten test
('ccF') and bootstrap multiple comparison's test ('ccboot').}

\item{sigT}{The signficance to be used for the multiple
comparison test; the default is 5\%.}

\item{sigF}{The signficance to be used for the F test of
ANOVA; the default is 5\%.}

\item{unfold}{Says what must be done after the ANOVA.
If NULL (\emph{default}), recommended tests are performed;
if '0', just ANOVA is performed; if '1', the simple effects
are tested.}
}
\value{
The output contains the ANOVA of the LSD, the
Shapiro-Wilk normality test for the residuals of the model,
the fitted regression models (when the treatments are
quantitative) and/or the multiple comparison tests (when the
treatments are qualitative).
}
\description{
\code{lastd} Analyses experiments in balanced Latin Square
Design, considering a fixed model.
}
\details{
The arguments sigT and mcomp will be used only
when the treatment are qualitative.
}
\examples{
data(ex3)
attach(ex3)
latsd(trat, linha, coluna, resp, quali = TRUE, mcomp = "snk",
sigT = 0.05, sigF = 0.05, unfold=NULL)
}
\references{
GOMES, F. P. Curso de Estatistica Experimental.
10a ed. Piracicaba: ESALQ/USP. 1982. 430.

FERREIRA, E. B.; CAVALCANTI, P. P.; NOGUEIRA D. A. Funcao
em codigo R para analisar experimentos em DQL simples, em
uma so rodada. In: CONGRESSO DE POS-GRADUACAO DA
UNIVERSIDADE FEDERAL DE LAVRAS, 18., 2009, Lavras.
Annals... Lavras: UFLA, 2009.
}
\seealso{
\code{\link{crd}}, \code{\link{rbd}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Portya Piscitelli Cavalcanti
 @note The \code{\link{graphics}} can be used to construct
 regression plots and \code{\link{plotres}} for residuals
 plots.
}
