% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat2.crd.R
\name{fat2.crd}
\alias{fat2.crd}
\title{Double factorial scheme in CRD}
\usage{
fat2.crd(
  factor1,
  factor2,
  resp,
  quali = c(TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2"),
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{factor1}{Numeric or complex vector containing the
factor 1 levels.}

\item{factor2}{Numeric or complex vector containing the
factor 2 levels.}

\item{resp}{Numeric or complex vector containing the
response variable.}

\item{quali}{Logic. If TRUE (default), the treatments
are assumed qualitative, if FALSE, quantitatives.}

\item{mcomp}{Allows choosing the multiple comparison
test; the \emph{default} is the test of Tukey, however,
the options are: the LSD test ('lsd'), the LSD test
with Bonferroni protection ('lsdb'), the test of Duncan
('duncan'), the test of Student-Newman-Keuls ('snk'),
the test of Scott-Knott ('sk'), the Calinski and
Corsten test ('ccF') and bootstrap multiple comparison's
test ('ccboot').}

\item{fac.names}{Allows labeling the factors 1 and 2.}

\item{sigT}{The signficance to be used for the multiple
comparison test; the default is 5\%.}

\item{sigF}{The signficance to be used for the F test
of ANOVA; the default is 5\%.}

\item{unfold}{Says what must be done after the ANOVA.
If NULL (\emph{default}), recommended tests are performed;
if '0', just ANOVA is performed; if '1', the simple effects
are tested; if '2', the double interaction is unfolded.}
}
\value{
The output contains the ANOVA of the referred
CRD, the Shapiro-Wilk normality test for the residuals
of the model, the fitted regression models (when the
treatments are quantitative) and/or the multiple
comparison tests (when the treatments are qualitative).
}
\description{
\code{fat2.crd} Analyses experiments in balanced
Completely Randomized Design in double factorial
scheme, considering a fixed model.
}
\details{
The arguments sigT and mcomp will be used only
when the treatment are qualitative.
}
\note{
The \code{\link{graphics}} can be used to
construct regression plots and \code{\link{plotres}}
for residuals plots.
}
\examples{
data(ex4)
attach(ex4)
fat2.crd(revol, esterco, zn, quali = c(FALSE,TRUE),
mcomp = "tukey", fac.names = c("Revolving","Manure"),
sigT = 0.05, sigF = 0.05, unfold=NULL)
}
\references{
BANZATTO, D. A.; KRONKA, S. N.
Experimentacao Agricola. 4 ed. Jaboticabal: Funep.
2006. 237 p.
}
\seealso{
\code{\link{crd}}, \code{\link{fat3.crd}},
\code{\link{split2.crd}}, \code{\link{fat2.ad.crd}} and
\code{\link{fat3.ad.crd}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
