% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ginv.R
\name{ginv}
\alias{ginv}
\title{Generalized inverse}
\usage{
ginv(X, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{X}{Matrix for which the Moore-Penrose inverse is
required.}

\item{tol}{A relative tolerance to detect zero singular
values.}
}
\value{
A MP generalized inverse matrix for X.
}
\description{
\code{ginv} Computes the Moore-Penrose generalized inverse
of a matrix X.
}
\references{
Venables, W. N. and Ripley, B. D. (1999) Modern
Applied Statistics with S-PLUS. Third Edition. Springer.
p.100.
}
\seealso{
\code{\link{solve}}, \code{\link{svd}},
\code{\link{eigen}}
}
