% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{worldbank}
\alias{worldbank}
\title{A Snapshot of Macroeconomic Data as Provided by the World Bank API (1960 - 2018)}
\format{
An object of class \code{"data.frame"}.
}
\source{
Has been collected using the \code{wbstats::wb()} function
 from the World Bank API in Dec 2020.
 The code to generate this data is available in the
 \href{https://github.com/joachim-gassen/ExPanDaR}{github repository} of this package.
 Use in scientific studies is not advised without prior cleaning/checking.
}
\usage{
data(worldbank)
}
\description{
Data collected from the World Bank API using the package \code{wbstats}.
}
\examples{
data(worldbank)
prepare_missing_values_graph(worldbank, ts_id = "year")

data(worldbank_data_def)
data(worldbank_var_def)
data(ExPanD_config_worldbank)
\dontrun{
  ExPanD(worldbank, df_def = worldbank_data_def,
    var_def = worldbank_var_def, config_list = ExPanD_config_worldbank)
}

}
\keyword{data}
\keyword{datasets}
\keyword{macroeconomic}
