% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_epinow.R
\name{regional_epinow}
\alias{regional_epinow}
\title{Real-time Rt Estimation, Forecasting and Reporting by Region}
\usage{
regional_epinow(
  data,
  generation_time = gt_opts(),
  delays = delay_opts(),
  truncation = trunc_opts(),
  rt = rt_opts(),
  backcalc = backcalc_opts(),
  gp = gp_opts(),
  obs = obs_opts(),
  forecast = forecast_opts(),
  stan = stan_opts(),
  horizon,
  CrIs = c(0.2, 0.5, 0.9),
  target_folder = NULL,
  target_date,
  non_zero_points = 2,
  output = c("regions", "summary", "samples", "plots", "latest"),
  return_output = is.null(target_folder),
  summary_args = list(),
  verbose = FALSE,
  logs = tempdir(check = TRUE),
  ...
)
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date
(date), and region (\code{region}).}

\item{generation_time}{A call to \code{\link[=gt_opts]{gt_opts()}} (or its alias
\code{\link[=generation_time_opts]{generation_time_opts()}}) defining the generation time distribution used.
For backwards compatibility a list of summary parameters can also be passed.}

\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{truncation}{A call to \code{\link[=trunc_opts]{trunc_opts()}} defining the truncation of
the observed data. Defaults to \code{\link[=trunc_opts]{trunc_opts()}}, i.e. no truncation.  See the
\code{\link[=estimate_truncation]{estimate_truncation()}} help file for an approach to estimating this from
data where the \code{dist} list element returned by \code{\link[=estimate_truncation]{estimate_truncation()}} is
used as the \code{truncation} argument here, thereby propagating the uncertainty
in the estimate.}

\item{rt}{A list of options as generated by \code{\link[=rt_opts]{rt_opts()}} defining Rt
estimation. Defaults to \code{\link[=rt_opts]{rt_opts()}}. To generate new infections using
the non-mechanistic model instead of the renewal equation model, use
\code{rt = NULL}. The non-mechanistic model internally uses the setting
\code{rt = rt_opts(use_rt = FALSE, future = "project", gp_on = "R0")}.}

\item{backcalc}{A list of options as generated by \code{\link[=backcalc_opts]{backcalc_opts()}} to
define the back calculation. Defaults to \code{\link[=backcalc_opts]{backcalc_opts()}}.}

\item{gp}{A list of options as generated by \code{\link[=gp_opts]{gp_opts()}} to define the
Gaussian process. Defaults to \code{\link[=gp_opts]{gp_opts()}}. Set to \code{NULL} to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{\link[=obs_opts]{obs_opts()}} defining the
observation model. Defaults to \code{\link[=obs_opts]{obs_opts()}}.}

\item{forecast}{A list of options as generated by \code{\link[=forecast_opts]{forecast_opts()}} defining
the forecast opitions. Defaults to \code{\link[=forecast_opts]{forecast_opts()}}. If NULL then no
forecasting will be done.}

\item{stan}{A list of stan options as generated by \code{\link[=stan_opts]{stan_opts()}}. Defaults
to \code{\link[=stan_opts]{stan_opts()}}. Can be used to override \code{data}, \code{init}, and \code{verbose}
settings if desired.}

\item{horizon}{Deprecated; use \code{forecast} instead to specify the predictive
horizon}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{target_folder}{Character string specifying where to save results (will
create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not
specified.}

\item{non_zero_points}{Numeric, the minimum number of time points with
non-zero cases in a region required for that region to be evaluated.
Defaults to 7.}

\item{output}{A character vector of optional output to return. Supported
options are the individual regional estimates ("regions"),  samples
("samples"), plots ("plots"), copying the individual region dated folder into
a latest folder (if \code{target_folder} is not null, set using "latest"), the
stan fit of the underlying model ("fit"), and an overall summary across
regions ("summary"). The default is to return samples and plots alongside
summarised estimates and summary statistics. If \code{target_folder} is not NULL
then the default is also to copy all results into a latest folder.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned,
this automatically updates to TRUE if no directory for saving is specified.}

\item{summary_args}{A list of arguments passed to \code{\link[=regional_summary]{regional_summary()}}. See
the \code{\link[=regional_summary]{regional_summary()}} documentation for details.}

\item{verbose}{Logical defaults to FALSE. Outputs verbose progress messages
to the console from \code{\link[=epinow]{epinow()}}.}

\item{logs}{Character path indicating the target folder in which to store log
information. Defaults to the temporary directory if not specified. Default
logging can be disabled if \code{logs} is set to NULL. If specifying a custom
logging setup then the code for \code{\link[=setup_default_logging]{setup_default_logging()}} and the
\code{\link[=setup_logging]{setup_logging()}} function are a sensible place to start.}

\item{...}{Pass additional arguments to \code{\link[=epinow]{epinow()}}. See the documentation for
\code{\link[=epinow]{epinow()}} for details.}
}
\value{
A list of output stratified at the top level into regional output
and across region output summary output
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Efficiently runs \code{\link[=epinow]{epinow()}} across multiple regions in an efficient manner
and conducts basic data checks and cleaning such as removing regions with
fewer than \code{non_zero_points} as these are unlikely to produce reasonable
results whilst consuming significant resources. See the documentation for
\code{\link[=epinow]{epinow()}} for further information.

By default all arguments supporting input from \verb{_opts()} functions are
shared across regions (including delays, truncation, Rt settings, stan
settings, and gaussian process settings). Region specific settings are
supported by passing a named list of \verb{_opts()} calls (with an entry per
region) to the relevant argument. A helper function (\code{\link[=opts_list]{opts_list()}}) is
available to facilitate building this list.

Regions can be estimated in parallel using the \code{{future}} package (see
\code{\link[=setup_future]{setup_future()}}). The progress of producing estimates across multiple
regions can be tracked using the \code{{progressr}} package. Modify this behaviour
using \code{\link[progressr:handlers]{progressr::handlers()}} and enable it in batch by setting
\code{R_PROGRESSR_ENABLE=TRUE} as an environment variable.
}
\examples{
\donttest{
# set number of cores to use
old_opts <- options()
options(mc.cores = ifelse(interactive(), 4, 1))

# uses example case vector
cases <- example_confirmed[1:60]
cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]
))

# run epinow across multiple regions and generate summaries
# samples and warmup have been reduced for this example
# for more examples, see the "estimate_infections examples" vignette
def <- regional_epinow(
  data = cases,
  generation_time = gt_opts(example_generation_time),
  delays = delay_opts(example_incubation_period + example_reporting_delay),
  rt = rt_opts(prior = LogNormal(mean = 2, sd = 0.2)),
  stan = stan_opts(
    samples = 100, warmup = 200
  ),
  verbose = interactive()
)
options(old_opts)
}
}
\seealso{
\code{\link[=epinow]{epinow()}} \code{\link[=estimate_infections]{estimate_infections()}} \code{\link[=setup_future]{setup_future()}}
\code{\link[=regional_summary]{regional_summary()}}
}
