% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.epi.data.frame.R
\name{plot.epi.data.frame}
\alias{plot.epi.data.frame}
\title{Plot Epidemic Model Results From a Netsim Data.Frame}
\usage{
\method{plot}{epi.data.frame}(
  x,
  y = NULL,
  sims = NULL,
  legend = NULL,
  mean.col = NULL,
  qnts.col = NULL,
  sim.lwd = NULL,
  sim.col = NULL,
  sim.alpha = NULL,
  popfrac = FALSE,
  qnts = 0.5,
  qnts.alpha = 0.5,
  qnts.smooth = TRUE,
  mean.line = TRUE,
  mean.smooth = TRUE,
  add = FALSE,
  mean.lwd = 2,
  mean.lty = 1,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  sim.lines = FALSE,
  grid = FALSE,
  leg.cex = 0.8,
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} obtain with \code{as.data.frame(netsim_object)}.}

\item{y}{Output compartments or flows from \code{netsim} object to plot.}

\item{sims}{If \code{type="epi"} or \code{"formation"}, a vector of
simulation numbers to plot. If \code{type="network"}, a single
simulation number for which to plot the network, or else \code{"min"}
to plot the simulation number with the lowest disease prevalence,
\code{"max"} for the simulation with the highest disease prevalence,
or \code{"mean"} for the simulation with the prevalence closest to the
mean across simulations at the specified time step.}

\item{legend}{If \code{TRUE}, plot default legend.}

\item{mean.col}{Vector of any standard R color format for mean lines.}

\item{qnts.col}{Vector of any standard R color format for polygons.}

\item{sim.lwd}{Line width for simulation lines.}

\item{sim.col}{Vector of any standard R color format for simulation lines.}

\item{sim.alpha}{Transparency level for simulation lines, where
0 = transparent and 1 = opaque (see \code{adjustcolor} function).}

\item{popfrac}{If \code{TRUE}, plot prevalence of values rather than numbers
(see details).}

\item{qnts}{If numeric, plot polygon of simulation quantiles based on the
range implied by the argument (see details). If \code{FALSE}, suppress
polygon from plot.}

\item{qnts.alpha}{Transparency level for quantile polygons, where 0 =
transparent and 1 = opaque (see \code{adjustcolor} function).}

\item{qnts.smooth}{If \code{TRUE}, use a loess smoother on quantile polygons.}

\item{mean.line}{If \code{TRUE}, plot mean of simulations across time.}

\item{mean.smooth}{If \code{TRUE}, use a loess smoother on the mean line.}

\item{add}{If \code{TRUE}, new plot window is not called and lines are added
to existing plot window.}

\item{mean.lwd}{Line width for mean lines.}

\item{mean.lty}{Line type for mean lines.}

\item{xlim}{the x limits (x1, x2) of the plot.  Note that \code{x1 > x2}
    is allowed and leads to a \sQuote{reversed axis}.

    The default value, \code{NULL}, indicates that the range of the
    \link{finite} values to be plotted should be used.}

\item{ylim}{the y limits of the plot.}

\item{main}{a main title for the plot, see also \code{\link[graphics]{title}}.}

\item{xlab}{a label for the x axis, defaults to a description of \code{x}.}

\item{ylab}{a label for the y axis, defaults to a description of \code{y}.}

\item{sim.lines}{If \code{TRUE}, plot individual simulation lines. Default is
to plot lines for one-group models but not for two-group models.}

\item{grid}{If \code{TRUE}, a grid is added to the background of plot
(see \code{\link{grid}} for details), with default of nx by ny.}

\item{leg.cex}{Legend scale size.}

\item{...}{Additional arguments to pass.}
}
\description{
This function is a wrapper around \code{plot.netsim} accepting a
\code{data.frame} obtain with \code{as.data.frame(netsim_object)}.
}
\keyword{plot}
