% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nowcastingR.R
\name{nowcastingR}
\alias{nowcastingR}
\title{Nowcasting the reproduction number}
\usage{
nowcastingR(data, day.effect = TRUE, ref.day = "Monday", si, method = c("M3", "M2"))
}
\arguments{
\item{data}{A data frame containing the data for each time and delay combination with
the following 6 columns. The first column is a numeric variable associated to the calendar date.
The second column is a numeric variable indicating the delay of reporting. The third column
corresponds to the calendar date of the event (e.g. death) and the fourth column to the
calendar date at which the event of interest was reported. The fifth column indicates the
number of cases for each time and delay combination. Finally, the sixth column indicates whether
the cases are already reported or not yet reported. To see an example of such a data structure
type \code{data("cov19incidence2022")} and then \code{head(cov19incidence2022)}. This will illustrate the
required data structure for nowcasting the reproduction number based on incidence data for
Belgium in 2022.}

\item{day.effect}{If TRUE (default), include the day of the week effect.}

\item{ref.day}{If \code{day.effect = TRUE}, then the reference category for
the day of the week must be specified. The default is "Monday".}

\item{si}{The (discrete) serial interval distribution.}

\item{method}{The model to be fitted, either M3 (default) or M2.}
}
\value{
A list with the following components:
\itemize{
 \item data: The data frame used as an input.
 \item Rnow: A data frame containing the nowcasted reproduction number.
 \item lambda_estim: Estimated penalty parameters of the P-splines model.
 \item phi_estim: Estimated overdispersion parameter from the negative binomial model.
 \item method: The model choice, i.e. either M3 or M2.
 }
}
\description{
This routine can be used to nowcast the time-varying reproduction number. Daily cases are typically
subject to reporting delays, so that the reported number of infected individuals is not always reflecting the
true epidemic status. Nowcasting aims to correct this underreporting phenomenon by estimating
the number of infections that have occurred but that have not yet been reported. The
latter number is then combined with the already reported cases and interpreted as a nowcast or
prediction for the true epidemic status regarding the number of daily cases. The routine
is anchored around Laplacian-P-splines in an epidemic context (Gressani et al. 2022) and the
detailed methodology can be found in Sumalinab et al. (2023). Two different models can be fitted,
named M3 (the default) and M2. M3 uses a joint approach that simultaneously models the delay dimension
and the time-varying reproduction number. M2 uses reported cases and a nowcast of the not yet reported
cases. See Sumalinab et al. (2023) and the vignette \url{https://epilps.com/NowcastingRt.html} for
more details.
}
\examples{
# data("cov19incidence2022")
# si_covid <- c(0.344, 0.316, 0.168, 0.104, 0.068) # serial interval distribution
# Sys.setlocale("LC_TIME", "English")              # set system locale to English
# Rnowfit <- nowcastingR(data = cov19incidence2022, si = si_covid)
# tail(Rnowfit$Rnow)
# plot(Rnowfit)

}
\references{
Gressani, O., Wallinga, J., Althaus, C. L., Hens, N. and Faes, C.
 (2022). EpiLPS: A fast and flexible Bayesian tool for estimation of the
 time-varying reproduction number. \emph{Plos Computational Biology},
 \strong{18}(10): e1010618.

Sumalinab, B., Gressani, O., Hens, N. and Faes, C. (2023). An
 efficient approach to nowcasting the time-varying reproduction number. MedRxiv preprint.
}
\author{
Bryan Sumalinab (writing) and Oswaldo Gressani (editing).
}
