% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incubsim.R
\name{incubsim}
\alias{incubsim}
\title{Simulation of incubation times}
\usage{
incubsim(incubdist = c("LogNormal","Weibull","MixWeibull", "Gamma"), coarseness = 1,
 n = 100, tmax = 20, tgridlen = 500, plotsim = FALSE)
}
\arguments{
\item{incubdist}{The distribution of the incubation period.}

\item{coarseness}{The average coarseness of the data. Default is 1 day.}

\item{n}{The sample size.}

\item{tmax}{The upper bound on which to evaluate the \code{incubdist} density.}

\item{tgridlen}{The number of grid points on which to evaluate the density.}

\item{plotsim}{Graphical visualization of the simulated data?}
}
\value{
A list including (among others) the left and right bounds of the
incubation period.
}
\description{
This routine simulates symptom onset times, generation times and left and
right bounds of infecting exposure windows for source-recipient pairs based
on a given incubation distribution and a generation time distribution. The
generation time distribution is assumed to be a Weibull with shape 2.826 and
scale 5.665 (Ferretti et al. 2020). The incubation distribution can be chosen
by the user among:

\itemize{
 \item{A LogNormal distribution with a mean of 5.5 days and standard deviation of
  2.1 days (Ferretti et al. 2020).}
 \item{A Weibull distribution (shape-scale parameterization) with a mean of 6.4 days and standard deviation of
  2.3 days (Backer et al. 2020).}
 \item{An artificial bimodal distribution constructed from a mixture of two
  Weibull distributions.}
 \item{A Gamma distribution (shape-rate parameterization) with a mean of 3.8 days and standard deviation of
2.9 days (Donnelly et al. 2003).}
 }
}
\examples{
simdat <- incubsim(n = 50) # Simulation of incubation times for 50 cases.
simdat$Dobsincub           # Left and right bounds of incubation period.

}
\references{
Ferretti, L., Wymant, C., Kendall, et al. (2020). Quantifying
SARS-CoV-2 transmission suggests epidemic control with digital contact
tracing. \emph{Science}, \strong{368}(6491), eabb6936.

Backer, J. A., Klinkenberg, D., & Wallinga, J. (2020). Incubation
period of 2019 novel coronavirus (2019-nCoV) infections among
travellers from Wuhan, China, 20–28 January 2020. \emph{Eurosurveillance},
\strong{25}(5), 2000062.

Donnelly, C. A., Ghani, A. C., Leung, G. M., et al. (2003).
Epidemiological determinants of spread of causal agent of severe acute
respiratory syndrome in Hong Kong. \emph{The Lancet}, \strong{361}(9371),
1761-1766.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
