// Generated by rstantools.  Do not edit by hand.

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_multi_steep_original_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'multi_steep_original', line 122, column 2 to column 37)",
                                                      " (in 'multi_steep_original', line 123, column 2 to column 38)",
                                                      " (in 'multi_steep_original', line 124, column 2 to column 42)",
                                                      " (in 'multi_steep_original', line 127, column 2 to column 33)",
                                                      " (in 'multi_steep_original', line 128, column 2 to column 34)",
                                                      " (in 'multi_steep_original', line 131, column 6 to column 68)",
                                                      " (in 'multi_steep_original', line 130, column 19 to line 132, column 5)",
                                                      " (in 'multi_steep_original', line 130, column 4 to line 132, column 5)",
                                                      " (in 'multi_steep_original', line 134, column 6 to column 47)",
                                                      " (in 'multi_steep_original', line 133, column 18 to line 135, column 5)",
                                                      " (in 'multi_steep_original', line 133, column 3 to line 135, column 5)",
                                                      " (in 'multi_steep_original', line 136, column 3 to column 26)",
                                                      " (in 'multi_steep_original', line 129, column 22 to line 137, column 3)",
                                                      " (in 'multi_steep_original', line 129, column 2 to line 137, column 3)",
                                                      " (in 'multi_steep_original', line 148, column 2 to column 38)",
                                                      " (in 'multi_steep_original', line 149, column 2 to column 27)",
                                                      " (in 'multi_steep_original', line 150, column 2 to column 32)",
                                                      " (in 'multi_steep_original', line 152, column 4 to column 35)",
                                                      " (in 'multi_steep_original', line 153, column 4 to column 113)",
                                                      " (in 'multi_steep_original', line 154, column 4 to column 71)",
                                                      " (in 'multi_steep_original', line 151, column 22 to line 155, column 3)",
                                                      " (in 'multi_steep_original', line 151, column 2 to line 155, column 3)",
                                                      " (in 'multi_steep_original', line 141, column 4 to column 28)",
                                                      " (in 'multi_steep_original', line 142, column 4 to column 32)",
                                                      " (in 'multi_steep_original', line 143, column 4 to column 48)",
                                                      " (in 'multi_steep_original', line 144, column 4 to column 102)",
                                                      " (in 'multi_steep_original', line 140, column 22 to line 145, column 3)",
                                                      " (in 'multi_steep_original', line 140, column 2 to line 145, column 3)",
                                                      " (in 'multi_steep_original', line 112, column 2 to column 17)",
                                                      " (in 'multi_steep_original', line 113, column 2 to column 17)",
                                                      " (in 'multi_steep_original', line 114, column 2 to column 22)",
                                                      " (in 'multi_steep_original', line 115, column 8 to column 9)",
                                                      " (in 'multi_steep_original', line 115, column 11 to column 17)",
                                                      " (in 'multi_steep_original', line 115, column 2 to column 39)",
                                                      " (in 'multi_steep_original', line 116, column 8 to column 9)",
                                                      " (in 'multi_steep_original', line 116, column 11 to column 17)",
                                                      " (in 'multi_steep_original', line 116, column 2 to column 38)",
                                                      " (in 'multi_steep_original', line 117, column 9 to column 10)",
                                                      " (in 'multi_steep_original', line 117, column 12 to column 13)",
                                                      " (in 'multi_steep_original', line 117, column 2 to column 24)",
                                                      " (in 'multi_steep_original', line 118, column 8 to column 9)",
                                                      " (in 'multi_steep_original', line 118, column 2 to column 26)",
                                                      " (in 'multi_steep_original', line 119, column 2 to column 23)",
                                                      " (in 'multi_steep_original', line 122, column 8 to column 14)",
                                                      " (in 'multi_steep_original', line 122, column 16 to column 17)",
                                                      " (in 'multi_steep_original', line 123, column 8 to column 14)",
                                                      " (in 'multi_steep_original', line 124, column 8 to column 14)",
                                                      " (in 'multi_steep_original', line 127, column 8 to column 14)",
                                                      " (in 'multi_steep_original', line 127, column 16 to column 17)",
                                                      " (in 'multi_steep_original', line 128, column 8 to column 14)",
                                                      " (in 'multi_steep_original', line 148, column 8 to column 14)",
                                                      " (in 'multi_steep_original', line 149, column 9 to column 15)",
                                                      " (in 'multi_steep_original', line 150, column 9 to column 15)",
                                                      " (in 'multi_steep_original', line 150, column 17 to column 18)",
                                                      " (in 'multi_steep_original', line 3, column 10 to column 11)",
                                                      " (in 'multi_steep_original', line 3, column 4 to column 25)",
                                                      " (in 'multi_steep_original', line 4, column 4 to column 15)",
                                                      " (in 'multi_steep_original', line 6, column 11 to column 12)",
                                                      " (in 'multi_steep_original', line 6, column 4 to column 21)",
                                                      " (in 'multi_steep_original', line 8, column 6 to column 30)",
                                                      " (in 'multi_steep_original', line 7, column 19 to line 9, column 5)",
                                                      " (in 'multi_steep_original', line 7, column 4 to line 9, column 5)",
                                                      " (in 'multi_steep_original', line 12, column 6 to column 86)",
                                                      " (in 'multi_steep_original', line 14, column 6 to column 75)",
                                                      " (in 'multi_steep_original', line 16, column 6 to column 34)",
                                                      " (in 'multi_steep_original', line 18, column 6 to column 44)",
                                                      " (in 'multi_steep_original', line 19, column 6 to column 50)",
                                                      " (in 'multi_steep_original', line 10, column 19 to line 20, column 7)",
                                                      " (in 'multi_steep_original', line 10, column 4 to line 20, column 7)",
                                                      " (in 'multi_steep_original', line 21, column 4 to column 18)",
                                                      " (in 'multi_steep_original', line 2, column 138 to line 22, column 3)",
                                                      " (in 'multi_steep_original', line 24, column 4 to column 19)",
                                                      " (in 'multi_steep_original', line 25, column 4 to column 15)",
                                                      " (in 'multi_steep_original', line 26, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 26, column 18 to column 23)",
                                                      " (in 'multi_steep_original', line 26, column 4 to column 43)",
                                                      " (in 'multi_steep_original', line 27, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 27, column 4 to column 30)",
                                                      " (in 'multi_steep_original', line 28, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 28, column 4 to column 25)",
                                                      " (in 'multi_steep_original', line 30, column 6 to column 30)",
                                                      " (in 'multi_steep_original', line 29, column 23 to line 31, column 5)",
                                                      " (in 'multi_steep_original', line 29, column 4 to line 31, column 5)",
                                                      " (in 'multi_steep_original', line 33, column 6 to column 64)",
                                                      " (in 'multi_steep_original', line 35, column 6 to column 34)",
                                                      " (in 'multi_steep_original', line 37, column 6 to column 44)",
                                                      " (in 'multi_steep_original', line 38, column 6 to column 50)",
                                                      " (in 'multi_steep_original', line 32, column 32 to line 39, column 5)",
                                                      " (in 'multi_steep_original', line 32, column 4 to line 39, column 5)",
                                                      " (in 'multi_steep_original', line 42, column 8 to column 55)",
                                                      " (in 'multi_steep_original', line 43, column 8 to column 44)",
                                                      " (in 'multi_steep_original', line 44, column 8 to column 50)",
                                                      " (in 'multi_steep_original', line 41, column 31 to line 45, column 7)",
                                                      " (in 'multi_steep_original', line 41, column 6 to line 45, column 7)",
                                                      " (in 'multi_steep_original', line 40, column 29 to line 46, column 5)",
                                                      " (in 'multi_steep_original', line 40, column 4 to line 46, column 5)",
                                                      " (in 'multi_steep_original', line 48, column 6 to column 36)",
                                                      " (in 'multi_steep_original', line 49, column 6 to column 51)",
                                                      " (in 'multi_steep_original', line 47, column 23 to line 50, column 5)",
                                                      " (in 'multi_steep_original', line 47, column 4 to line 50, column 5)",
                                                      " (in 'multi_steep_original', line 51, column 4 to column 23)",
                                                      " (in 'multi_steep_original', line 23, column 112 to line 52, column 3)",
                                                      " (in 'multi_steep_original', line 55, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 55, column 4 to column 21)",
                                                      " (in 'multi_steep_original', line 56, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 56, column 4 to column 21)",
                                                      " (in 'multi_steep_original', line 57, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 57, column 4 to column 21)",
                                                      " (in 'multi_steep_original', line 58, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 58, column 4 to column 22)",
                                                      " (in 'multi_steep_original', line 60, column 4 to column 15)",
                                                      " (in 'multi_steep_original', line 61, column 4 to column 16)",
                                                      " (in 'multi_steep_original', line 62, column 4 to column 15)",
                                                      " (in 'multi_steep_original', line 63, column 4 to column 16)",
                                                      " (in 'multi_steep_original', line 65, column 11 to column 16)",
                                                      " (in 'multi_steep_original', line 65, column 4 to column 27)",
                                                      " (in 'multi_steep_original', line 66, column 4 to column 10)",
                                                      " (in 'multi_steep_original', line 67, column 4 to column 10)",
                                                      " (in 'multi_steep_original', line 69, column 4 to column 21)",
                                                      " (in 'multi_steep_original', line 73, column 6 to column 12)",
                                                      " (in 'multi_steep_original', line 74, column 6 to column 12)",
                                                      " (in 'multi_steep_original', line 77, column 10 to column 20)",
                                                      " (in 'multi_steep_original', line 76, column 29 to line 78, column 9)",
                                                      " (in 'multi_steep_original', line 76, column 8 to line 78, column 9)",
                                                      " (in 'multi_steep_original', line 80, column 10 to column 20)",
                                                      " (in 'multi_steep_original', line 79, column 30 to line 81, column 9)",
                                                      " (in 'multi_steep_original', line 79, column 8 to line 81, column 9)",
                                                      " (in 'multi_steep_original', line 75, column 21 to line 82, column 7)",
                                                      " (in 'multi_steep_original', line 75, column 6 to line 82, column 7)",
                                                      " (in 'multi_steep_original', line 85, column 10 to column 20)",
                                                      " (in 'multi_steep_original', line 84, column 29 to line 86, column 9)",
                                                      " (in 'multi_steep_original', line 84, column 8 to line 86, column 9)",
                                                      " (in 'multi_steep_original', line 88, column 10 to column 20)",
                                                      " (in 'multi_steep_original', line 87, column 30 to line 89, column 9)",
                                                      " (in 'multi_steep_original', line 87, column 8 to line 89, column 9)",
                                                      " (in 'multi_steep_original', line 83, column 33 to line 90, column 7)",
                                                      " (in 'multi_steep_original', line 83, column 6 to line 90, column 7)",
                                                      " (in 'multi_steep_original', line 91, column 6 to column 44)",
                                                      " (in 'multi_steep_original', line 72, column 23 to line 92, column 5)",
                                                      " (in 'multi_steep_original', line 72, column 4 to line 92, column 5)",
                                                      " (in 'multi_steep_original', line 94, column 4 to column 21)",
                                                      " (in 'multi_steep_original', line 95, column 4 to column 17)",
                                                      " (in 'multi_steep_original', line 97, column 6 to column 40)",
                                                      " (in 'multi_steep_original', line 96, column 23 to line 98, column 5)",
                                                      " (in 'multi_steep_original', line 96, column 4 to line 98, column 5)",
                                                      " (in 'multi_steep_original', line 99, column 4 to column 26)",
                                                      " (in 'multi_steep_original', line 100, column 4 to column 34)",
                                                      " (in 'multi_steep_original', line 101, column 4 to column 89)",
                                                      " (in 'multi_steep_original', line 103, column 4 to column 35)",
                                                      " (in 'multi_steep_original', line 104, column 4 to column 25)",
                                                      " (in 'multi_steep_original', line 105, column 4 to column 19)",
                                                      " (in 'multi_steep_original', line 106, column 4 to column 18)",
                                                      " (in 'multi_steep_original', line 107, column 4 to column 35)",
                                                      " (in 'multi_steep_original', line 108, column 4 to column 18)",
                                                      " (in 'multi_steep_original', line 53, column 54 to line 109, column 3)"};
template <typename T0__, typename T1__, typename T2__, typename T7__>
std::vector<stan::promote_args_t<T0__, T1__, stan::value_type_t<T2__>,
T7__>>
ProbFunction(const std::vector<T0__>& EloStart, const T1__& k,
             const T2__& presence_arg__, const int& N, const int& K,
             const std::vector<int>& Ai, const std::vector<int>& loser,
             const T7__& diff_f, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          stan::value_type_t<T2__>,
          T7__>;
  const auto& presence = to_ref(presence_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 55;
    validate_non_negative_index("result", "N", N);
    std::vector<local_scalar_t__> result;
    result = std::vector<local_scalar_t__>(N, DUMMY_VAR__);
    
    local_scalar_t__ toAdd;
    toAdd = DUMMY_VAR__;
    
    current_statement__ = 58;
    validate_non_negative_index("EloNow", "K", K);
    Eigen::Matrix<local_scalar_t__, -1, 1> EloNow;
    EloNow = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
    stan::math::fill(EloNow, DUMMY_VAR__);
    
    current_statement__ = 62;
    for (int j = 1; j <= K; ++j) {
      current_statement__ = 60;
      assign(EloNow, cons_list(index_uni(j), nil_index_list()),
        EloStart[(j - 1)], "assigning variable EloNow");}
    current_statement__ = 69;
    for (int i = 1; i <= N; ++i) {
      current_statement__ = 63;
      assign(EloNow, nil_index_list(),
        subtract(stan::model::deep_copy(EloNow),
          (dot_product(row(presence, i), EloNow) / sum(row(presence, i)))),
        "assigning variable EloNow");
      current_statement__ = 64;
      assign(result, cons_list(index_uni(i), nil_index_list()),
        (1 /
          (1 +
            stan::math::exp(
              (diff_f *
                (EloNow[(loser[(i - 1)] - 1)] - EloNow[(Ai[(i - 1)] - 1)]))))),
        "assigning variable result");
      current_statement__ = 65;
      toAdd = ((1 - result[(i - 1)]) * k);
      current_statement__ = 66;
      assign(EloNow, cons_list(index_uni(Ai[(i - 1)]), nil_index_list()),
        (EloNow[(Ai[(i - 1)] - 1)] + toAdd), "assigning variable EloNow");
      current_statement__ = 67;
      assign(EloNow, cons_list(index_uni(loser[(i - 1)]), nil_index_list()),
        (EloNow[(loser[(i - 1)] - 1)] - toAdd), "assigning variable EloNow");
    }
    current_statement__ = 70;
    return result;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct ProbFunction_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T7__>
std::vector<stan::promote_args_t<T0__, T1__, stan::value_type_t<T2__>,
T7__>>
operator()(const std::vector<T0__>& EloStart, const T1__& k,
           const T2__& presence, const int& N, const int& K,
           const std::vector<int>& Ai, const std::vector<int>& loser,
           const T7__& diff_f, std::ostream* pstream__)  const 
{
return ProbFunction(EloStart, k, presence, N, K, Ai, loser, diff_f,
         pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
T1__>, -1, 1>
cum_winprob(const T0__& EloStart_arg__, const T1__& k,
            const int& n_interactions, const int& n_ids,
            const std::vector<int>& Ai, const std::vector<int>& loser,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__>;
  const auto& EloStart = to_ref(EloStart_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ single_wp;
    single_wp = DUMMY_VAR__;
    
    local_scalar_t__ toAdd;
    toAdd = DUMMY_VAR__;
    
    current_statement__ = 74;
    validate_non_negative_index("pairwise_winprobs", "n_ids", n_ids);
    current_statement__ = 75;
    validate_non_negative_index("pairwise_winprobs", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, -1> pairwise_winprobs;
    pairwise_winprobs = Eigen::Matrix<local_scalar_t__, -1, -1>(n_ids, n_ids);
    stan::math::fill(pairwise_winprobs, DUMMY_VAR__);
    
    current_statement__ = 77;
    validate_non_negative_index("cumwinprobs", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> cumwinprobs;
    cumwinprobs = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(cumwinprobs, DUMMY_VAR__);
    
    current_statement__ = 79;
    validate_non_negative_index("EloNow", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> EloNow;
    EloNow = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(EloNow, DUMMY_VAR__);
    
    current_statement__ = 83;
    for (int j = 1; j <= n_ids; ++j) {
      current_statement__ = 81;
      assign(EloNow, cons_list(index_uni(j), nil_index_list()),
        EloStart[(j - 1)], "assigning variable EloNow");}
    current_statement__ = 89;
    for (int i = 1; i <= n_interactions; ++i) {
      current_statement__ = 84;
      single_wp = (1 /
                    (1 +
                      stan::math::exp(
                        (EloNow[(loser[(i - 1)] - 1)] -
                          EloNow[(Ai[(i - 1)] - 1)]))));
      current_statement__ = 85;
      toAdd = ((1 - single_wp) * k);
      current_statement__ = 86;
      assign(EloNow, cons_list(index_uni(Ai[(i - 1)]), nil_index_list()),
        (EloNow[(Ai[(i - 1)] - 1)] + toAdd), "assigning variable EloNow");
      current_statement__ = 87;
      assign(EloNow, cons_list(index_uni(loser[(i - 1)]), nil_index_list()),
        (EloNow[(loser[(i - 1)] - 1)] - toAdd), "assigning variable EloNow");
    }
    current_statement__ = 96;
    for (int i = 1; i <= (n_ids - 1); ++i) {
      current_statement__ = 94;
      for (int j = (i + 1); j <= n_ids; ++j) {
        current_statement__ = 90;
        single_wp = (1 /
                      (1 +
                        stan::math::exp((EloNow[(i - 1)] - EloNow[(j - 1)]))));
        current_statement__ = 91;
        assign(pairwise_winprobs,
          cons_list(index_uni(j), cons_list(index_uni(i), nil_index_list())),
          single_wp, "assigning variable pairwise_winprobs");
        current_statement__ = 92;
        assign(pairwise_winprobs,
          cons_list(index_uni(i), cons_list(index_uni(j), nil_index_list())),
          (1.0 - single_wp), "assigning variable pairwise_winprobs");}}
    current_statement__ = 100;
    for (int i = 1; i <= n_ids; ++i) {
      current_statement__ = 97;
      assign(pairwise_winprobs,
        cons_list(index_uni(i), cons_list(index_uni(i), nil_index_list())),
        0.0, "assigning variable pairwise_winprobs");
      current_statement__ = 98;
      assign(cumwinprobs, cons_list(index_uni(i), nil_index_list()),
        sum(
          rvalue(pairwise_winprobs,
            cons_list(index_uni(i),
              cons_list(index_omni(), nil_index_list())),
            "pairwise_winprobs")), "assigning variable cumwinprobs");}
    current_statement__ = 101;
    return cumwinprobs;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cum_winprob_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
T1__>, -1, 1>
operator()(const T0__& EloStart, const T1__& k, const int& n_interactions,
           const int& n_ids, const std::vector<int>& Ai,
           const std::vector<int>& loser, std::ostream* pstream__)  const 
{
return cum_winprob(EloStart, k, n_interactions, n_ids, Ai, loser, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
cumwinprob2steep(const T0__& nds_arg__, const int& n_ids,
                 std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& nds = to_ref(nds_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 103;
    validate_non_negative_index("A1", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> A1;
    A1 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(A1, DUMMY_VAR__);
    
    current_statement__ = 105;
    validate_non_negative_index("A2", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> A2;
    A2 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(A2, DUMMY_VAR__);
    
    current_statement__ = 107;
    validate_non_negative_index("B1", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> B1;
    B1 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(B1, DUMMY_VAR__);
    
    current_statement__ = 109;
    validate_non_negative_index("AB1", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> AB1;
    AB1 = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(AB1, DUMMY_VAR__);
    
    local_scalar_t__ sum_y;
    sum_y = DUMMY_VAR__;
    
    local_scalar_t__ sum_x2;
    sum_x2 = DUMMY_VAR__;
    
    local_scalar_t__ sum_x;
    sum_x = DUMMY_VAR__;
    
    local_scalar_t__ sum_xy;
    sum_xy = DUMMY_VAR__;
    
    current_statement__ = 115;
    validate_non_negative_index("theranks", "n_ids", n_ids);
    Eigen::Matrix<local_scalar_t__, -1, 1> theranks;
    theranks = Eigen::Matrix<local_scalar_t__, -1, 1>(n_ids);
    stan::math::fill(theranks, DUMMY_VAR__);
    
    int r;
    r = std::numeric_limits<int>::min();
    
    int s;
    s = std::numeric_limits<int>::min();
    
    Eigen::Matrix<local_scalar_t__, -1, 1> xsteep;
    xsteep = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
    stan::math::fill(xsteep, DUMMY_VAR__);
    
    current_statement__ = 140;
    for (int i = 1; i <= n_ids; ++i) {
      current_statement__ = 120;
      r = 1;
      current_statement__ = 121;
      s = 1;
      current_statement__ = 129;
      for (int j = 1; j <= i; ++j) {
        current_statement__ = 124;
        if (logical_lt(nds[(j - 1)], nds[(i - 1)])) {
          current_statement__ = 122;
          r = (r + 1);
        } 
        current_statement__ = 127;
        if (logical_eq(nds[(j - 1)], nds[(i - 1)])) {
          current_statement__ = 125;
          s = (s + 1);
        } }
      current_statement__ = 137;
      for (int j = (i + 1); j <= n_ids; ++j) {
        current_statement__ = 132;
        if (logical_lt(nds[(j - 1)], nds[(i - 1)])) {
          current_statement__ = 130;
          r = (r + 1);
        } 
        current_statement__ = 135;
        if (logical_eq(nds[(j - 1)], nds[(i - 1)])) {
          current_statement__ = 133;
          s = (s + 1);
        } }
      current_statement__ = 138;
      assign(theranks, cons_list(index_uni(i), nil_index_list()),
        ((r + ((s - 1) * 0.5)) - 0.5), "assigning variable theranks");}
    current_statement__ = 141;
    sum_y = sum(nds);
    current_statement__ = 142;
    sum_x2 = 0.0;
    current_statement__ = 145;
    for (int i = 1; i <= n_ids; ++i) {
      current_statement__ = 143;
      sum_x2 = (sum_x2 + pow(theranks[(i - 1)], 2));}
    current_statement__ = 146;
    sum_x = sum(theranks);
    current_statement__ = 147;
    sum_xy = sum(elt_multiply(nds, theranks));
    current_statement__ = 148;
    assign(xsteep, cons_list(index_uni(1), nil_index_list()),
      (((sum_y * sum_x2) - (sum_x * sum_xy)) /
        ((n_ids * sum_x2) - pow(sum_x, 2))), "assigning variable xsteep");
    current_statement__ = 149;
    assign(A1, nil_index_list(), subtract(theranks, mean(theranks)),
      "assigning variable A1");
    current_statement__ = 150;
    assign(B1, nil_index_list(), subtract(nds, mean(nds)),
      "assigning variable B1");
    current_statement__ = 151;
    assign(AB1, nil_index_list(), elt_multiply(A1, B1),
      "assigning variable AB1");
    current_statement__ = 152;
    assign(A2, nil_index_list(), elt_multiply(A1, A1),
      "assigning variable A2");
    current_statement__ = 153;
    assign(xsteep, cons_list(index_uni(2), nil_index_list()),
      (sum(AB1) / sum(A2)), "assigning variable xsteep");
    current_statement__ = 154;
    return xsteep;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cumwinprob2steep_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
operator()(const T0__& nds, const int& n_ids, std::ostream* pstream__)  const 
{
return cumwinprob2steep(nds, n_ids, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_multi_steep_original final : public model_base_crtp<model_multi_steep_original> {
private:
  int N;
  int K;
  int n_rand;
  std::vector<std::vector<int>> winner;
  std::vector<std::vector<int>> loser;
  Eigen::Matrix<double, -1, -1> presence;
  std::vector<int> y;
  double diff_f;
 
public:
  ~model_multi_steep_original() { }
  
  inline std::string model_name() const final { return "model_multi_steep_original"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_multi_steep_original(stan::io::var_context& context__,
                             unsigned int random_seed__ = 0,
                             std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_multi_steep_original_namespace::model_multi_steep_original";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 29;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 29;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 29;
      current_statement__ = 29;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 30;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 30;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 30;
      current_statement__ = 30;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 31;
      context__.validate_dims("data initialization","n_rand","int",
          context__.to_vec());
      n_rand = std::numeric_limits<int>::min();
      
      current_statement__ = 31;
      n_rand = context__.vals_i("n_rand")[(1 - 1)];
      current_statement__ = 31;
      current_statement__ = 31;
      check_greater_or_equal(function__, "n_rand", n_rand, 1);
      current_statement__ = 32;
      validate_non_negative_index("winner", "N", N);
      current_statement__ = 33;
      validate_non_negative_index("winner", "n_rand", n_rand);
      current_statement__ = 34;
      context__.validate_dims("data initialization","winner","int",
          context__.to_vec(N, n_rand));
      winner = std::vector<std::vector<int>>(N, std::vector<int>(n_rand, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> winner_flat__;
        current_statement__ = 34;
        assign(winner_flat__, nil_index_list(), context__.vals_i("winner"),
          "assigning variable winner_flat__");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 34;
            assign(winner,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              winner_flat__[(pos__ - 1)], "assigning variable winner");
            current_statement__ = 34;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 34;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 34;
        for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
          current_statement__ = 34;
          current_statement__ = 34;
          check_greater_or_equal(function__, "winner[sym1__, sym2__]",
                                 winner[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 35;
      validate_non_negative_index("loser", "N", N);
      current_statement__ = 36;
      validate_non_negative_index("loser", "n_rand", n_rand);
      current_statement__ = 37;
      context__.validate_dims("data initialization","loser","int",
          context__.to_vec(N, n_rand));
      loser = std::vector<std::vector<int>>(N, std::vector<int>(n_rand, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> loser_flat__;
        current_statement__ = 37;
        assign(loser_flat__, nil_index_list(), context__.vals_i("loser"),
          "assigning variable loser_flat__");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
          current_statement__ = 37;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 37;
            assign(loser,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              loser_flat__[(pos__ - 1)], "assigning variable loser");
            current_statement__ = 37;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 37;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 37;
        for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
          current_statement__ = 37;
          current_statement__ = 37;
          check_greater_or_equal(function__, "loser[sym1__, sym2__]",
                                 loser[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 38;
      validate_non_negative_index("presence", "N", N);
      current_statement__ = 39;
      validate_non_negative_index("presence", "K", K);
      current_statement__ = 40;
      context__.validate_dims("data initialization","presence","double",
          context__.to_vec(N, K));
      presence = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(presence, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> presence_flat__;
        current_statement__ = 40;
        assign(presence_flat__, nil_index_list(),
          context__.vals_r("presence"), "assigning variable presence_flat__");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 40;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 40;
            assign(presence,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              presence_flat__[(pos__ - 1)], "assigning variable presence");
            current_statement__ = 40;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 41;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 42;
      context__.validate_dims("data initialization","y","int",
          context__.to_vec(N));
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 42;
      assign(y, nil_index_list(), context__.vals_i("y"),
        "assigning variable y");
      current_statement__ = 42;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 42;
        current_statement__ = 42;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 43;
      context__.validate_dims("data initialization","diff_f","double",
          context__.to_vec());
      diff_f = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 43;
      diff_f = context__.vals_r("diff_f")[(1 - 1)];
      current_statement__ = 43;
      current_statement__ = 43;
      check_greater_or_equal(function__, "diff_f", diff_f, 0);
      current_statement__ = 44;
      validate_non_negative_index("EloStart_raw", "n_rand", n_rand);
      current_statement__ = 45;
      validate_non_negative_index("EloStart_raw", "K", K);
      current_statement__ = 46;
      validate_non_negative_index("k_raw", "n_rand", n_rand);
      current_statement__ = 47;
      validate_non_negative_index("sigma_raw", "n_rand", n_rand);
      current_statement__ = 48;
      validate_non_negative_index("EloStart", "n_rand", n_rand);
      current_statement__ = 49;
      validate_non_negative_index("EloStart", "K", K);
      current_statement__ = 50;
      validate_non_negative_index("k", "n_rand", n_rand);
      current_statement__ = 51;
      validate_non_negative_index("sigma", "n_rand", n_rand);
      current_statement__ = 52;
      validate_non_negative_index("steepness", "n_rand", n_rand);
      current_statement__ = 53;
      validate_non_negative_index("cumwinprobs", "n_rand", n_rand);
      current_statement__ = 54;
      validate_non_negative_index("cumwinprobs", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += n_rand * K;
      num_params_r__ += n_rand;
      num_params_r__ += n_rand;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_multi_steep_original_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<std::vector<local_scalar_t__>> EloStart_raw;
      EloStart_raw = std::vector<std::vector<local_scalar_t__>>(n_rand, std::vector<local_scalar_t__>(K, DUMMY_VAR__));
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 1;
          assign(EloStart_raw,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable EloStart_raw");}}
      std::vector<local_scalar_t__> k_raw;
      k_raw = std::vector<local_scalar_t__>(n_rand, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 2;
        assign(k_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable k_raw");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(k_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(k_raw[(sym1__ - 1)], 0.0, lp__),
            "assigning variable k_raw");
        } else {
          current_statement__ = 2;
          assign(k_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(k_raw[(sym1__ - 1)], 0.0),
            "assigning variable k_raw");
        }}
      std::vector<local_scalar_t__> sigma_raw;
      sigma_raw = std::vector<local_scalar_t__>(n_rand, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_raw");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(sigma_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_raw[(sym1__ - 1)], 0.0, lp__),
            "assigning variable sigma_raw");
        } else {
          current_statement__ = 3;
          assign(sigma_raw, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_raw[(sym1__ - 1)], 0.0),
            "assigning variable sigma_raw");
        }}
      std::vector<std::vector<local_scalar_t__>> EloStart;
      EloStart = std::vector<std::vector<local_scalar_t__>>(n_rand, std::vector<local_scalar_t__>(K, DUMMY_VAR__));
      
      std::vector<local_scalar_t__> k;
      k = std::vector<local_scalar_t__>(n_rand, DUMMY_VAR__);
      
      current_statement__ = 14;
      for (int r = 1; r <= n_rand; ++r) {
        current_statement__ = 8;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 6;
          assign(EloStart,
            cons_list(index_uni(r),
              cons_list(index_uni(i), nil_index_list())),
            (EloStart_raw[(r - 1)][(i - 1)] -
              mean(
                rvalue(EloStart_raw,
                  cons_list(index_uni(r),
                    cons_list(index_omni(), nil_index_list())),
                  "EloStart_raw"))), "assigning variable EloStart");}
        current_statement__ = 11;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 9;
          assign(EloStart,
            cons_list(index_uni(r),
              cons_list(index_uni(i), nil_index_list())),
            (EloStart[(r - 1)][(i - 1)] / diff_f),
            "assigning variable EloStart");}
        current_statement__ = 12;
        assign(k, cons_list(index_uni(r), nil_index_list()),
          (k_raw[(r - 1)] / diff_f), "assigning variable k");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 5;
        current_statement__ = 5;
        check_greater_or_equal(function__, "k[sym1__]", k[(sym1__ - 1)], 0.0);
      }
      {
        current_statement__ = 28;
        for (int r = 1; r <= n_rand; ++r) {
          current_statement__ = 23;
          lp_accum__.add(normal_lpdf<propto__>(k_raw[(r - 1)], 0, 1));
          current_statement__ = 24;
          lp_accum__.add(normal_lpdf<propto__>(sigma_raw[(r - 1)], 0, 1));
          current_statement__ = 25;
          lp_accum__.add(
            normal_lpdf<propto__>(
              rvalue(EloStart_raw,
                cons_list(index_uni(r),
                  cons_list(index_omni(), nil_index_list())), "EloStart_raw"),
              0, sigma_raw[(r - 1)]));
          current_statement__ = 26;
          lp_accum__.add(
            bernoulli_lpmf<propto__>(y,
              ProbFunction(
                rvalue(EloStart,
                  cons_list(index_uni(r),
                    cons_list(index_omni(), nil_index_list())), "EloStart"),
                k[(r - 1)], presence, N, K,
                rvalue(winner,
                  cons_list(index_omni(),
                    cons_list(index_uni(r), nil_index_list())), "winner"),
                rvalue(loser,
                  cons_list(index_omni(),
                    cons_list(index_uni(r), nil_index_list())), "loser"),
                diff_f, pstream__)));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_multi_steep_original_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<std::vector<double>> EloStart_raw;
      EloStart_raw = std::vector<std::vector<double>>(n_rand, std::vector<double>(K, std::numeric_limits<double>::quiet_NaN()));
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 1;
          assign(EloStart_raw,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())), in__.scalar(),
            "assigning variable EloStart_raw");}}
      std::vector<double> k_raw;
      k_raw = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 2;
        assign(k_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable k_raw");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 2;
        assign(k_raw, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(k_raw[(sym1__ - 1)], 0.0),
          "assigning variable k_raw");}
      std::vector<double> sigma_raw;
      sigma_raw = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_raw");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_raw, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_raw[(sym1__ - 1)], 0.0),
          "assigning variable sigma_raw");}
      std::vector<std::vector<double>> EloStart;
      EloStart = std::vector<std::vector<double>>(n_rand, std::vector<double>(K, std::numeric_limits<double>::quiet_NaN()));
      
      std::vector<double> k;
      k = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
          vars__.emplace_back(EloStart_raw[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        vars__.emplace_back(k_raw[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        vars__.emplace_back(sigma_raw[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 14;
      for (int r = 1; r <= n_rand; ++r) {
        current_statement__ = 8;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 6;
          assign(EloStart,
            cons_list(index_uni(r),
              cons_list(index_uni(i), nil_index_list())),
            (EloStart_raw[(r - 1)][(i - 1)] -
              mean(
                rvalue(EloStart_raw,
                  cons_list(index_uni(r),
                    cons_list(index_omni(), nil_index_list())),
                  "EloStart_raw"))), "assigning variable EloStart");}
        current_statement__ = 11;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 9;
          assign(EloStart,
            cons_list(index_uni(r),
              cons_list(index_uni(i), nil_index_list())),
            (EloStart[(r - 1)][(i - 1)] / diff_f),
            "assigning variable EloStart");}
        current_statement__ = 12;
        assign(k, cons_list(index_uni(r), nil_index_list()),
          (k_raw[(r - 1)] / diff_f), "assigning variable k");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 5;
        current_statement__ = 5;
        check_greater_or_equal(function__, "k[sym1__]", k[(sym1__ - 1)], 0.0);
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
            vars__.emplace_back(EloStart[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
          vars__.emplace_back(k[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<double> sigma;
      sigma = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> steepness;
      steepness = Eigen::Matrix<double, -1, 1>(n_rand);
      stan::math::fill(steepness, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> cumwinprobs;
      cumwinprobs = Eigen::Matrix<double, -1, -1>(n_rand, K);
      stan::math::fill(cumwinprobs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 22;
      for (int r = 1; r <= n_rand; ++r) {
        current_statement__ = 18;
        assign(sigma, cons_list(index_uni(r), nil_index_list()),
          (sigma_raw[(r - 1)] / diff_f), "assigning variable sigma");
        current_statement__ = 19;
        assign(cumwinprobs,
          cons_list(index_uni(r), cons_list(index_omni(), nil_index_list())),
          to_row_vector(
            cum_winprob(
              to_vector(
                rvalue(EloStart,
                  cons_list(index_uni(r),
                    cons_list(index_omni(), nil_index_list())), "EloStart")),
              k[(r - 1)], N, K,
              rvalue(winner,
                cons_list(index_omni(),
                  cons_list(index_uni(r), nil_index_list())), "winner"),
              rvalue(loser,
                cons_list(index_omni(),
                  cons_list(index_uni(r), nil_index_list())), "loser"), pstream__)),
          "assigning variable cumwinprobs");
        current_statement__ = 20;
        assign(steepness, cons_list(index_uni(r), nil_index_list()),
          cumwinprob2steep(
  to_vector(
    rvalue(cumwinprobs,
      cons_list(index_uni(r), cons_list(index_omni(), nil_index_list())),
      "cumwinprobs")), K, pstream__)[
          (2 - 1)], "assigning variable steepness");}
      current_statement__ = 15;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 15;
        current_statement__ = 15;
        check_greater_or_equal(function__, "sigma[sym1__]",
                               sigma[(sym1__ - 1)], 0.0);}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        vars__.emplace_back(steepness[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
          vars__.emplace_back(
            rvalue(cumwinprobs,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "cumwinprobs"));}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<std::vector<double>> EloStart_raw;
      EloStart_raw = std::vector<std::vector<double>>(n_rand, std::vector<double>(K, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> EloStart_raw_flat__;
        current_statement__ = 1;
        assign(EloStart_raw_flat__, nil_index_list(),
          context__.vals_r("EloStart_raw"),
          "assigning variable EloStart_raw_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
            current_statement__ = 1;
            assign(EloStart_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              EloStart_raw_flat__[(pos__ - 1)],
              "assigning variable EloStart_raw");
            current_statement__ = 1;
            pos__ = (pos__ + 1);}}
      }
      std::vector<double> k_raw;
      k_raw = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(k_raw, nil_index_list(), context__.vals_r("k_raw"),
        "assigning variable k_raw");
      std::vector<double> k_raw_free__;
      k_raw_free__ = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 2;
        assign(k_raw_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(k_raw[(sym1__ - 1)], 0.0),
          "assigning variable k_raw_free__");}
      std::vector<double> sigma_raw;
      sigma_raw = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(sigma_raw, nil_index_list(), context__.vals_r("sigma_raw"),
        "assigning variable sigma_raw");
      std::vector<double> sigma_raw_free__;
      sigma_raw_free__ = std::vector<double>(n_rand, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_raw_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_raw[(sym1__ - 1)], 0.0),
          "assigning variable sigma_raw_free__");}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          vars__.emplace_back(EloStart_raw[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        vars__.emplace_back(k_raw_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        vars__.emplace_back(sigma_raw_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("EloStart_raw");
    names__.emplace_back("k_raw");
    names__.emplace_back("sigma_raw");
    names__.emplace_back("EloStart");
    names__.emplace_back("k");
    names__.emplace_back("sigma");
    names__.emplace_back("steepness");
    names__.emplace_back("cumwinprobs");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_rand),
                                             static_cast<size_t>(K)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "EloStart_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_raw" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "EloStart" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "steepness" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "cumwinprobs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "EloStart_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k_raw" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_raw" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "EloStart" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_rand; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "steepness" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n_rand; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "cumwinprobs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"EloStart_raw\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"k_raw\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_raw\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"EloStart\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"steepness\",\"type\":{\"name\":\"vector\",\"length\":" << n_rand << "},\"block\":\"generated_quantities\"},{\"name\":\"cumwinprobs\",\"type\":{\"name\":\"matrix\",\"rows\":" << n_rand << ",\"cols\":" << K << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"EloStart_raw\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"parameters\"},{\"name\":\"k_raw\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_raw\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"EloStart\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << n_rand << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"steepness\",\"type\":{\"name\":\"vector\",\"length\":" << n_rand << "},\"block\":\"generated_quantities\"},{\"name\":\"cumwinprobs\",\"type\":{\"name\":\"matrix\",\"rows\":" << n_rand << ",\"cols\":" << K << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_multi_steep_original_namespace::model_multi_steep_original;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_multi_steep_original_namespace::profiles__;
}
#endif
#endif
