% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_dyads.R
\name{remove_dyads}
\alias{remove_dyads}
\title{remove interactions from matrix to increase sparseness}
\usage{
remove_dyads(
  m,
  removal_mode = c("mix", "by_interaction", "by_dyad"),
  stop_at = 0.5,
  max_out = NULL
)
}
\arguments{
\item{m}{input matrix}

\item{removal_mode}{character, should interactions be removed interaction by
interaction (\code{"by_interaction"}), or by removing one dyad
entirely at a time (\code{"by_dyad"}). Default is \code{"mix"}, i.e.
a random mix between the two strategies.}

\item{stop_at}{numeric, fraction of unknown relationships to be reached}

\item{max_out}{numeric, the number of matrices to be returned maximally.
This is useful if the input matrix is fairly large. If set, this
will return the input matrix plus \code{max_out} randomly selected
matrices from the remaining produced matrices. So in fact, the output
comprises \code{max_out + 1} matrices (subject to the \code{stop_at}
specification).}
}
\value{
a list with two items. \code{$summary} is a data frame with an
overview. \code{matrices} contains the actual interaction
matrices with increasing proportion of unknown relationships.
}
\description{
remove interactions from matrix to increase sparseness
}
\examples{
data(bonobos)
res <- remove_dyads(bonobos)
res$summary
length(res$matrices)
lapply(res$matrices, prunk)

res <- remove_dyads(bonobos, max_out = 2)
# first plus two randomly selected = 3 matrices
length(res$matrices)
res$summary
}
