% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scores.R
\name{plot_scores}
\alias{plot_scores}
\title{plot posteriors of individual scores}
\usage{
plot_scores(
  x,
  adjustpar = 4,
  color = TRUE,
  subset_ids = NULL,
  include_others = TRUE
)
}
\arguments{
\item{x}{result from \code{\link{elo_steepness_from_matrix}},
\code{\link{elo_steepness_from_sequence}} or
\code{\link{davids_steepness}}}

\item{adjustpar}{numeric, parameter for smoothing posterior of individual
scores}

\item{color}{logical, default is \code{TRUE} where individuals get
color-coded. If \code{FALSE}: a gray scale is used. It is
also possible to hand over a vector with colors, which then
must correspond in length to the number of individuals.}

\item{subset_ids}{character, plot only those individual codes. Default is
\code{NULL}, i.e. all individuals are included in the plot.}

\item{include_others}{logical, should other IDs (those \emph{not} in
\code{subset_ids}) be included as contours. Default is \code{TRUE}.
This only has an effect if \code{subset_ids} is different from
\code{NULL},}
}
\value{
a plot
}
\description{
either summed winning probabilities or David's scores
}
\examples{
data(dommats, package = "EloRating")

res <- elo_steepness_from_matrix(dommats$elephants, n_rand = 1,
                                 silent = TRUE, refresh = 0,
                                 iter = 1000, warmup = 500)
plot_scores(res)

res <- davids_steepness(dommats$elephants, refresh = 0)
plot_scores(res)
plot_scores(res, color = FALSE)
plot_scores(res, adjustpar = 0.3)
}
