% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastdaypresent.R
\name{lastdaypresent}
\alias{lastdaypresent}
\title{last day an individual was present}
\usage{
lastdaypresent(x, ID = "all", refdate = NULL)
}
\arguments{
\item{x}{output from \code{\link{elo.seq}}}

\item{ID}{character, if \code{"all"}, all individuals are returned, otherwise only for the desired ID}

\item{refdate}{character or Date (YYYY-MM-DD), up to which date the presence data should be considered, by default the last date of the sequene}
}
\value{
Date or \code{NA}
}
\description{
last day an individual was present with respect to a reference date
}
\details{
the function can result in \code{NA} for two reasons. 1) the ID is not found in the presence data, which is accompanied by a warning and 2) the ID was not yet present if a referene date is specified
}
\examples{
data(adv)
data(advpres)
SEQ <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date,
               presence = advpres)
lastdaypresent(SEQ, ID = "all", refdate = "2010-01-02")
lastdaypresent(SEQ, ID = "f", refdate = "2010-02-02")
}
\author{
Christof Neumann
}
