% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyadic_reversals.R
\name{dyadic_reversals}
\alias{dyadic_reversals}
\title{changes in dyadic relationships}
\usage{
dyadic_reversals(eloobject, cutpoint = NULL, daterange = NULL)
}
\arguments{
\item{eloobject}{result from \code{\link{elo.seq}}}

\item{cutpoint}{character or Date, the date at which to split into pre and
post (default is \code{NULL}, where the data is split in
halves). The actual date here will be included in the 'pre'
period.}

\item{daterange}{character or Date of length 2, the date range to be
considered (default is \code{NULL} where the entire date
range in the data is used)}
}
\value{
a data.frame with one line per dyad:
\describe{
\item{id1,id2}{the dyad}
\item{pre_n,post_n}{the number of interactions for that dyad pre and
                    post cutpoint date}
\item{pre,post}{which of the two was dominant (\code{1} = id1, \code{2} =
                id2, \code{0} = tied relationship, \code{NA} = unknown
                relationship, i.e. 0 interactions)}
}
}
\description{
compare dyadic relationships before and after a certain date
}
\examples{
data(adv)
eloobject <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date)
# split at halfway point ("2010-01-17")
# one reversal: a-f
dyadic_reversals(eloobject)
# shift split date so that both interactions for a/f occur in the post period,
# which makes it a tie in post and unknown in pre
dyadic_reversals(eloobject, cutpoint = "2010-01-10")
}
