% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raterprog.R
\name{raterprog}
\alias{raterprog}
\alias{raterprogplot}
\title{reliability with progressive rater inclusion}
\usage{
raterprog(winner, loser, raterID, runs=100, ratershuffle=1, progbar=TRUE, kval=100,
startvalue=0, normprob=FALSE)

raterprogplot(xdata)
}
\arguments{
\item{winner}{character, vector with the IDs of the winning (preferred) stimuli}

\item{loser}{character, vector with the IDs of the losing (not preferred) stimuli}

\item{raterID}{a vector (numeric, character, factor) with rater IDs}

\item{runs}{numeric, number of randomizations}

\item{ratershuffle}{numeric, number of times rater order is reshuffled/randomized}

\item{progbar}{logical, should a progress bar be displayed}

\item{kval}{numeric, k-value, which determines the maximum number of points a stimulus' rating can change after a single rating event, by default 100}

\item{startvalue}{numeric, start value around which ratings are centered, by default \code{0}}

\item{normprob}{logical, by default \code{FALSE}, which indicates a logistic approach is taken for calculating winning probabilities (see Elo 1978). Alternatively (\code{TRUE}), winning probabilities are calculated from a normal distribution}

\item{xdata}{results from \code{\link{raterprog}}}
}
\value{
a numeric matrix. Rows correspond to number of raters in the data set, while columns reflect the number of times the rater order is reshuffled.
}
\description{
reliability with progressive rater inclusion
}
\details{
\code{raterprog()} calculates \code{\link{reliability}}, increasing the number of raters to be included in the rating process in a step-wise fashion. In the first (and by default only one) run, the first rater is the one that appears first in the data set, and in subsequent steps raters are added by the order in which they occur. If \code{ratershuffle=} is set to values larger than 1, the order in which raters are included is randomized.

\code{raterprogplot()} plots the matrix resulting from \code{raterprog()}. If \code{ratershuffle=} is larger than 1, the average reliability index is plotted alongside quartiles and results from the original rater inclusion sequence.

Note that the function currently only calculates the weighted version of the \code{\link{reliability}} index.
}
\examples{
data("physical")
# limit to 12 raters
physical <- physical[physical$raterID < 14, ]

x <- raterprog(physical$Winner, physical$Loser, physical$raterID, ratershuffle = 1)
raterprogplot(x)
\donttest{
# with multiple orders in which raters are added
x <- raterprog(physical$Winner, physical$Loser, physical$raterID, ratershuffle = 10)
raterprogplot(x)}
}
\references{
\insertRef{clark2018}{EloChoice}
}
\author{
Christof Neumann after suggestion by TF
}
