% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_auxiliaryFunctions.R
\name{derivative.psi}
\alias{derivative.psi}
\alias{f1}
\alias{f2}
\title{Computing \eqn{\psi}, its inverse \eqn{\Psi} and the \eqn{k}-th derivative of \eqn{\Psi}}
\usage{
derivative.psi(x, a, d, k, inverse)

f1(x, d, k = 0)

f2(x, a, d, k = 0)
}
\arguments{
\item{x}{a numeric value}

\item{a}{a parameter \eqn{a > 0} that reduces the bias of the estimator around zero}

\item{d}{the dimension of the data}

\item{k}{the order of derivative.
If \code{k = 0}, then the original function value is returned.
If \code{k > 0}, the value of its derivative is returned.}

\item{inverse}{if \code{inverse = TRUE}, then the inverse of \eqn{\Psi} is
of interest. Otherwise, the function \eqn{\psi} is used for the computation}
}
\value{
A numeric value \eqn{\psi(x)^{(k)}} if \code{inverse = TRUE},
otherwise \eqn{\Psi(x)^{(k)}}.

The functions \code{f1} and \code{f2} also return a numeric value
}
\description{
The function \eqn{\psi} is used to estimate the generator of elliptical distribution.
It depends on the parameter \eqn{a}, which reduces the bias of the estimator around zero.
The functions \code{f1} and \code{f2} are already implemented in \code{derivative.psi}.
They are required to compute higher derivatives of \eqn{\Psi}.
}
\section{Functions}{
\itemize{
\item \code{f1()}: \eqn{f_1(x) = x^{2/d}}

\item \code{f2()}: \eqn{f_2(x) = (x + a)^{d/2} - a^{d/2}}

}}
\note{
The derivatives of \eqn{\psi} is not yet implemented. The function \eqn{\psi}
is defined as \eqn{\psi(x) = -a + (a^{d/2} + x^{d/2})^{2/d}}.
For any \eqn{a > 0} and \eqn{x > 0}, it has an inverse.
Let \eqn{\Psi} be the inverse function of \eqn{\psi}, then
\deqn{\Psi(x) = ((x+a)^{d/2} - a^{d/2})^{2/d} = (f_1 \circ f_2)(x).}
}
\examples{

# Return the 5-th derivative of the inverse of psi
derivative.psi(x = 1, a = 1, d = 3, k = 5, inverse = TRUE)

# Return psi
derivative.psi(x = 1, a = 1, d = 3, k = 0, inverse = FALSE)

}
\references{
Ryan, V., & Derumigny, A. (2024).
On the choice of the two tuning parameters for nonparametric estimation of an
elliptical distribution generator
\href{https://arxiv.org/abs/2408.17087}{arxiv:2408.17087}.
}
\seealso{
\code{\link{derivative.tau}} and \code{\link{derivative.rho}}.
\code{\link{vectorized_Faa_di_Bruno}} which is used for the computation
of the derivatives.
}
\author{
Victor Ryan, Alexis Derumigny
}
\keyword{internal}
