% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elrEffects.R
\name{elrEffects}
\alias{elrEffects}
\title{Average and conditional effects based on generalized linear models}
\usage{
elrEffects(object, x, from = 0, to = 1, type = "difference", subset. = NULL)
}
\arguments{
\item{object}{User defined generalized linear model (or another statistical model with a suitable predict method)}

\item{x}{Treatment variable (character string)}

\item{from}{from and to (values of treatment variable) specify the considered change in the treatment variable for the effect computation}

\item{to}{from and to (values of treatment variable) specify the considered change in the treatment variable for the effect computation}

\item{type}{character. Indicates the type of effect considered. Can be one of \code{"ATE"} (with aliases \code{"difference"} and \code{"Average Treatment Effect"} and \code{"Average of Differences"}), \code{"SRA"} (with alias \code{"Simple Ratio of Averages"}), or \code{"ORA"} (with alias \code{"Odds Ratio of Averages"}), \code{"ASR"} (with aliases \code{"ratio"} and \code{"Average of Simple Ratios"}), \code{"AOR"} (with aliases \code{"oddsratio"} and \code{"Average of Odds Ratios"}).}

\item{subset.}{Logical vector for computing effects in a subset of the data (conditional effects).}
}
\value{
Object of class elreffects
}
\description{
This function can be used to estimate average and conditional effects of a 
treatment variable on an outcome variable, taking into account any number of 
continuous and categorical covariates. It takes a user defined generalized
linear model (or another statistical model with a suitable predict method) 
as input and computes the corresponding effects.
}
\examples{
## Example with a logistic regression
m1logreg <- glm(y ~ x+z1+z2+k1+k2, data=elrdata_logreg,  family=binomial)
elrEffects(m1logreg, "x", from="0", to="1", type="difference", subset.=NULL)
}
