% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network_Ecotone.R
\name{NetworkEcoSeries}
\alias{NetworkEcoSeries}
\title{Networkeco for data series}
\usage{
NetworkEcoSeries(ecotonefinder, threshold = 0.8, method = c("cmeans",
  "vegclust"), plot.type = c("percentage", "heatmap", "corrplot",
  "network"), plot = c("species", "community"), no.plot = FALSE,
  order.sp = NULL, dist.method = "inner_product", dist = c("count",
  "relative", "raw"), network.group = c("site", "cluster"),
  method.corr = "number", ...)
}
\arguments{
\item{ecotonefinder}{A list containing elements named in the same way than
EcotoneFinderSeries function outcomes. Must contain cmeans results or
vegclust results.}

\item{threshold}{If dist = "count", the membership grade threshold used to
sort the species in the different clusters.}

\item{method}{The membership computation method to be used. Must be present
in the ecotonefinder list.}

\item{plot.type}{Which graphical representation to be plotted. Among
"percentage", "corrplot", "heatmap","network"}

\item{plot}{If plot = "species", the distances are computed between the
species in the data. If plot = "community", the distances are computed
between the cluster centroids.}

\item{no.plot}{Logical. Should the plot be displayed?. Set to TRUE to gain
computation time with large community matrix.}

\item{order.sp}{Vector providing the order in which to arrange the species.
If NULL, the column order will be kept.}

\item{dist.method}{Distance method for the computation of a distance matrix,
when dist = "raw" or dist = "percent".}

\item{dist}{The type of data on which distance calculations are made from. If
dist = "raw", the distance matrix is computed from the membership matrix
directly. if dist = "relative", the distance matrix is computed from the
relative memberships grades of each species in the clusters (between 0 and
1). If dist = "count", the species are assigned to clusters according to
the threshold and the distance matrix is computed from the number of common
species between the different clusters. See details.}

\item{network.group}{If network.group = "site" the nodes of the networks will
be colored according to the different times or sites of the series. If
network.group = "cluster" the nodes of the network will be colored
according to the different fuzzy clusters. Can be user defined (see qgraph
documentation for details) but must be a factor of the same lenght as the
nodes of the graph.}

\item{method.corr}{If plot.type = "corrplot", the method to be used for the
corrplot. Must be one of "circle", "square", "ellipse", "number", "shade",
"color", "pie". Default to "number".}

\item{...}{Additional arguments to be passed to the plotting functions, see
details.}
}
\value{
A list containing the percentage matrix, the distance matrix and the
  network object (depending of the arguments passed to the function)
}
\description{
Networkeco for data series
}
\details{
NetworkEcoSeries is a generalisation of the NetworkEco function to
  analyses space/time series. The ... argument may be used to pass additional
  arguments to the plotting functions (for graphical purposes).
}
\examples{
  \donttest{
  SyntheticTrialSeries <- SyntheticDataSeries(CommunityPool = 40,
                                              CommunityNum = 4, SpCo = NULL,
                                              Length = 500, SeriesNum = 5,
                                              Parameters = list(a=rep(60, 4),
                                                              b=c(0,200,350,500),
                                                              c=rep(0.03,4)),
                                              pal = c("#008585", "#B8CDAE", "#E6C186", "#C7522B"),
                                              replacement = TRUE,
                                              Parameters.repl = TRUE)

  EcoTimeSeriesTrial <- EcotoneFinderSeries(data = SyntheticTrialSeries,
                                            dist = "Distance",
                                            method = c("cmeans","vegclust"),
                                            series = "Time", groups = 4,
                                            standardize = "hellinger", na.rm=TRUE)

#### Network from the common number of species above membership threshold between clusters:
  SyntheticNetworkSeries <- NetworkEcoSeries(EcoTimeSeriesTrial, threshold = .2,
                                             method = "cmeans", plot.type = "network",
                                             plot = "community", dist = "count",
                                             network.group = "cluster",
                                             dist.method = "inner_product",
                                             no.plot = FALSE, layout = "spring",
                                             shape = "ellipse",
                                             palette = "colorblind")

#### Network of relations between species from their raw membership values in each cluster:
  SyntheticNetworkSeries <- NetworkEcoSeries(EcoTimeSeriesTrial, threshold = .2,
                                             method = "cmeans", plot.type = "network",
                                             plot = "species", dist = "raw",
                                             dist.method = "inner_product",
                                             no.plot = FALSE, layout = "spring",
                                             shape = "ellipse",
                                             palette = "colorblind")
 }

}
