% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotEcotone.R
\name{CommunityColor}
\alias{CommunityColor}
\title{Tool to assign color to species distribution plots given fuzzy clustering
results.}
\usage{
CommunityColor(ecotonefinder, method = c("vegclust", "cmeans"),
  pal = c("diverge_hcl", "terrain_hcl", "sequential_hcl", "rainbow_hcl"))
}
\arguments{
\item{ecotonefinder}{A list containing elements named in the same way than
EcotoneFinder function outcomes. Must contain at least one of vegclust or
cmeans results.}

\item{method}{Which fuzzy clustering to use. Either vegclust or cmeans.}

\item{pal}{Which palette to use for color picking. Chosen from the colorspace
package.}
}
\value{
A vector of color names from the palette in the pal argument, of the
  same length and in the same order than the species columns of the provided
  data.
}
\description{
Tool to assign color to species distribution plots given fuzzy clustering
results.
}
\details{
CommunityColor creates a color vector that can be used by plotting
  functions. It assigns colors to species of a community matrix given the
  results of vegclust or cmeans analyses (using cmeans$centers or
  vegclust$mobileCenters). Species are assigned to a color according to the
  cluster centroid for which they have their highest membership value (see
  Bandelj et al., 2012).

  The palette must be one of the colorspace package.
}
\examples{
 ######## Artificial dataset & analysis:
 SyntheticTrial <- SyntheticData(SpeciesNum = 27, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.03,3)),
                                 dev.c = .015,
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 SyntheticEcoFinder <- EcotoneFinder(SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all", groups = 3,
                                     standardize = "hellinger",
                                     diversity = "all")

 ##### Assigning colors to communities:
 SyntheticColor <- CommunityColor(SyntheticEcoFinder, pal = "diverge_hcl",
                   method = "cmeans")

 #### Plotting:
 plotEcotone(data = SyntheticEcoFinder, plot.data = TRUE, plot.method = "none",
             col.data = SyntheticColor)



}
