% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exit_mat.r
\name{exit_mat}
\alias{exit_mat}
\title{Generate a matrix of exit events from two regions - industries matrices (same matrix composition from two different periods)}
\usage{
exit_mat(mat1, mat2)
}
\arguments{
\item{mat1}{An incidence matrix with regions in rows and industries in columns (period 1)}

\item{mat2}{An incidence matrix with regions in rows and industries in columns (period 2)}
}
\value{
A matrix representing the exit events from two regions - industries matrices, with rows representing regions and columns representing industries
}
\description{
This function generates a matrix of exit events from two regions - industries matrices (different matrix compositions are allowed)
}
\examples{
## generate a first region - industry matrix in which cells represent the presence/absence
## of a RCA (period 1)
set.seed(31)
mat1 <- matrix(sample(0:1, 20, replace = TRUE), ncol = 4)
rownames(mat1) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat1) <- c("I1", "I2", "I3", "I4")

## generate a second region - industry matrix in which cells represent the presence/absence
## of a RCA (period 2)
mat2 <- mat1
mat2[2, 1] <- 0


## run the function
exit_mat(mat1, mat2)
}
\references{
Boschma, R., Balland, P.A. and Kogler, D. (2015) Relatedness and Technological Change in Cities: The rise and fall of technological knowledge in U.S. metropolitan areas from 1981 to 2010, \emph{Industrial and Corporate Change} \strong{24} (1): 223-250 \cr
\cr
Boschma, R., Heimeriks, G. and Balland, P.A. (2014) Scientific Knowledge Dynamics and Relatedness in Bio-Tech Cities, \emph{Research Policy} \strong{43} (1): 107-114
}
\seealso{
\code{\link{growth_list}}, \code{\link{exit_list}}, \code{\link{entry_list}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl} \cr
Wolf-Hendrik Uhlbach \email{w.p.uhlbach@students.uu.nl}
}
\keyword{diversification}
