% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ETdiagnosis.R
\name{plot.ETdiagnosis}
\alias{plot.ETdiagnosis}
\title{This function enables the creation of the principle graphics resulting from the create.ETdiagnosis function.
 The function returns the principal plots of the global ET-Diagnosis routine: the graphics of the biomass, accessible biomass...rates for the different effort multipliers, the Biomass Trophic Spectra (BTS) for the different effort multipliers, the B/Bref(mE=1) and Y/Yref graphs for the main TL classes and the Catch Trophic Spectra (CTS) (global and per fleet).}
\usage{
\method{plot}{ETdiagnosis}(
  x,
  scale = NULL,
  maxrange = NULL,
  legend.cex = NULL,
  ask = interactive(),
  ...
)
}
\arguments{
\item{x}{is the list object returned by the create.ETdiagnosis function.}

\item{scale}{is the scale parameter of the Biomass Trophic Spectra, can be log or by default the standard scale of results.}

\item{maxrange}{is the maximum TL wanted for the x-axis. By default maxrange = 5.5.}

\item{legend.cex}{defines the value of the cex for the legend.}

\item{ask}{default value is interactive. Parameter used to enable the user to control the display of each graph.}

\item{\dots}{plot other arguments}
}
\description{
This function enables the creation of the principle graphics resulting from the create.ETdiagnosis function.
 The function returns the principal plots of the global ET-Diagnosis routine: the graphics of the biomass, accessible biomass...rates for the different effort multipliers, the Biomass Trophic Spectra (BTS) for the different effort multipliers, the B/Bref(mE=1) and Y/Yref graphs for the main TL classes and the Catch Trophic Spectra (CTS) (global and per fleet).
}
\examples{
data(ecopath_guinee)
diagn.list<-create.ETdiagnosis(create.ETmain(ecopath_guinee),same.mE=TRUE)
plot(diagn.list)
}
