% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragStat.r
\name{fragStat}
\alias{fragStat}
\title{Compute quantiles, mean and standard deviation for two electrodes groups}
\usage{
fragStat(frag, groupIndex = NULL, groupName = "SOZ", ranked = FALSE)
}
\arguments{
\item{frag}{A Fragility object from \code{calcAdjFrag}}

\item{groupIndex}{Integer or string. A group of electrodes to mark}

\item{groupName}{Character. Name of the group of electrodes, default is "SOZ"}

\item{ranked}{Logical. If TRUE, use the ranked fragility matrix from Fragility object}
}
\value{
list of 5 items with quantile matrix, mean and sdv from both electrodes groups
}
\description{
Compute quantiles, mean and standard deviation for two electrodes groups
}
\examples{
data("pt01Frag")
data("pt01EcoG")    
## sozNames is the name of the electrodes we assume are in the SOZ
sozNames <- metaData(pt01EcoG)$sozNames
pt01fragstat <- fragStat(frag = pt01Frag, groupIndex = sozNames)
}
