% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETDQualitizer.R
\name{report_data_quality_table}
\alias{report_data_quality_table}
\title{Summarize and Report Data Quality Metrics}
\usage{
report_data_quality_table(dq_table)
}
\arguments{
\item{dq_table}{A `data.frame` containing data quality metrics. Must include columns `file`, `eye`, `target_id`, and relevant numeric metrics such as `offset`, `rms_s2s`, and `std`.
This would generally be created by concatenating the output of the compute_data_quality_from_validation() for multiple files.}
}
\value{
A named list with two elements:
\describe{
  \item{txt}{A character string summarizing key metrics (accuracy, RMS-S2S precision, STD precision).}
  \item{measures}{A list containing:
    \itemize{
      \item{\code{all}: A data frame with per-participant averages (grouped by `file`).}
      \item{\code{mean}, \code{std}, \code{min}, \code{max}: Named numeric vectors with summary statistics across participants.}
    }
  }
}
}
\description{
This function summarizes data quality metrics from a validation procedure by computing averages per participant and generating descriptive statistics across participants.
It also returns a formatted textual summary suitable for reporting.
}
\details{
The summary text excludes BCEA and data loss metrics. BCEA is considered a niche metric and data loss is best reported across the full dataset rather than just the validation subset.
}
\examples{
\dontrun{
result <- report_data_quality_table(dq_table)
cat(result$txt)
head(result$measures$all)
}

}
