% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResInd.R
\name{ResInd}
\alias{ResInd}
\title{Estimate resilience indicators (log-variance, lag-1 autocorrelation, and skewness) from daily milk production records}
\usage{
ResInd(
  production_df,
  dim_filter_range = c(1, 7, 203, 210),
  outlier_sd_threshold = 4,
  weight = "weight_AIC",
  trait,
  DIM,
  ID_col
)
}
\arguments{
\item{production_df}{A list containing data frames with the daily production records (actual or predicted) obtained from the LacCurveFit function}

\item{dim_filter_range}{A numeric vector with the lower and upper limits used to filter out lactation records at the beginning and end of lactation. If no filtering is needed, set the first two values to the minimum days in milk and the last two to the maximum}

\item{outlier_sd_threshold}{A numeric threshold defining the maximum number of standard deviations allowed for resilience indicator values before considering them outliers}

\item{weight}{The name of the column containing the selected ensemble prediction. Default is "weight_AIC"}

\item{trait}{The name of the column containing daily milking records}

\item{DIM}{The name of the column containing days in milk records}

\item{ID_col}{The name of the column containing the unique individual IDs}
}
\value{
A list containing: (1) the daily milk production values after filtering, (2) a list of removed individuals, and (3) a data frame with the resilience indicators
}
\description{
Estimate resilience indicators (log-variance, lag-1 autocorrelation, and skewness) from daily milk production records
}
