% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_estimates.R
\name{evaluate_estimates}
\alias{evaluate_estimates}
\title{evaluate_estimates}
\usage{
evaluate_estimates(f, e, n)
}
\arguments{
\item{f}{A list consisting of three elements: 1) the factual Sigma ((m + 1) x (m + 1) matrix of finite numeric elements); 2) the factual sigma_y^2 (vector of length 1, finite numeric element); 3) the factual mu ((m + 1) x 1 matrix of finite numeric elements).}

\item{e}{Analogous to parameter f but with estimates instead of factuals.}

\item{n}{The number of time moments used for obtaining parameter e (vector of length  1, finite positive integer).}
}
\value{
Calculated accuracy metric value (vector of length 1, numeric element). The lower the value, the better the accuracy, with 0 indicating perfect accuracy.
}
\description{
Calculates a discrepancy-function-based metric of accuracy of the statistical measure estimates for the output-differenced version of the single-output cumulative structural equation model with an additive-noise output measurement equation and assumptions of normality and independence. Suitable when there are no contradictions in the factuals/estimates.
}
\examples{
set.seed(1)

m <- 4
k <- 2

L <- matrix(runif((m + 1) * k, min = -10, max = 10), nrow = m + 1)
sigma <- matrix(runif(m + 2, min = 0, max = 10), nrow = m + 2)
mu <- matrix(runif(m + 1, min = -10, max = 10), nrow = m + 1)

n <- 100
data <- generate_data(n, L, sigma, mu)

Sigma <- L \%*\% t(L) + diag(sigma[1:(m + 1), ] ^ 2)
sigma_y_squared <- sigma[m + 2, ] ^ 2
Sigma[m + 1, m + 1] <- Sigma[m + 1, m + 1] + 2 * sigma_y_squared

factual_parameters <- list(Sigma, sigma_y_squared, mu)
estimated_parameters <- estimate_parameters(data, 0.00001)

evaluate_estimates(factual_parameters, estimated_parameters, n)

}
