% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_parameters_on.R
\name{estimate_parameters_on}
\alias{estimate_parameters_on}
\title{estimate_parameters_on}
\usage{
estimate_parameters_on(dat, s)
}
\arguments{
\item{dat}{An (n + 1) x (m + 1) data frame of finite numeric elements (possibly except for row 1, columns 1 to m) containing observed input (columns 1 to m) and output (column m + 1) data of the original model.}

\item{s}{Initial value of parameter s (a vector of length 1 containing a finite numeric element that belongs to the interval [0, 1]).}
}
\value{
A list containing n sublists, each representing a progressively larger data sample (with 1 to n observation points), where each sublist consists of three elements: 1) estimate of the covariance at lag 0 of the data that result from the output-differenced model (an (m + 1) x (m + 1) matrix of numeric elements); 2) estimate of the only non-zero element of the negative covariance at lag 1 of the data that result from the output-differenced model (a vector of length 1 containing a numeric element); 3) estimate of the mean of the data that result from the output-differenced model (an (m + 1) x 1 matrix of numeric elements).
}
\description{
Online maximum likelihood estimation of the statistical measures of the output-differenced version of the single-output cumulative structural equation model with an additive-noise output measurement equation and assumptions of normality and independence.
}
\examples{
set.seed(1)

m <- 4
k <- 2

L <- matrix(runif((m + 1) * k, min = -10, max = 10), nrow = m + 1)
sigma <- matrix(runif(m + 2, min = 0, max = 10), nrow = m + 2)
mu <- matrix(runif(m + 1, min = -10, max = 10), nrow = m + 1)

data <- generate_data(100, L, sigma, mu)

estimate_parameters_on(data, 0.35)

}
\references{
Vytautas Dulskis & Leonidas Sakalauskas (2025). Toward Efficient Online Estimation of Dynamic Structural Equation Models: A Case Study. Journal of Statistical Computation and Simulation, 1-24. DOI: 10.1080/00949655.2025.2515955
}
