% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMAR.R
\name{fitstat}
\alias{fitstat}
\title{Fit statistics for model assessment}
\usage{
fitstat(obj)
}
\arguments{
\item{obj}{fitted model of the class lm, nls, gls, gnls, lme, or nlme.}
}
\value{
Model.name: fitted model name, p: number of parameters in the fitted model, n: number of observation, SSR: residual sum of squares, TRE: total relative error, Bias: mean bias, MRB: mean relative bias, MAB: mean absolute bias, MAPE: mean absolute percentage error, MSE: mean squared error, RMSE: root mean square error, Percent.RMSE: percentage root mean squared error, R2: coefficient of determination, R2adj: adjusted coefficient of determination, APC: Amemiya's prediction criterion, logL: Log-likelihood, AIC: Akaike information criterion, AICc: corrected Akaike information criterion, BIC: Bayesian information criterion, HQC: Hannan-Quin information criterion.
}
\description{
This function helps users to generate 16 fit indices for model assessment. Once a model(s) is fitted, users can apply the function \code{\link[=fitstat]{fitstat()}} to get the indices.
}
\note{
The lower the better for the SSR, TRE, Bias, MRB, MAB, MAPE, MSE, RMSE, Percent.RMSE, APC, AIC, AICc, BIC and HQC indices. The higher the better for R2 and R2adj indices. Users can choose which indices to use to evaluate their models from the output.
}
\examples{
library(EMAR)

# sample data
Age <- 1:50
Yield <- exp(6.5 - 39.5/Age)
fit_data <- data.frame(Age, Yield)

# fit your model(s)
Eq01 <- lm(Yield ~ Age, data=fit_data)
Eq02 <- nls(Yield ~ b0 * Age ^ b1, data=fit_data, start=list(b0 = 2, b1 = 1))

# Get the fit statistics for the model(s)
fitstat(Eq01)
fitstat(Eq02)

# with the 'rbind' function, Users can generate output for multiple models at once.
indices <- rbind(fitstat(Eq01), fitstat(Eq02))
print(indices)
}
\seealso{
\code{\link[=valstat]{valstat()}}, which gives the fit indices of the model based on the independent/validation data
}
\author{
Ogana F.N. and Corral-Rivas S.
}
\keyword{fitstat}
