% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractMed.R
\name{extractMed}
\alias{extractMed}
\title{Extract medication information from clinical notes}
\usage{
extractMed(note_fn, drugnames, drgunit, windowlength, max_edit_dist = 0, ...)
}
\arguments{
\item{note_fn}{File name(s) for the text file(s) containing the clinical notes. Can be
a character string for an individual note, or a vector or list of file names for
multiple notes.}

\item{drugnames}{Vector of drug names for which dosing information should be extracted.
Can include various forms (e.g., generic, brand name) as well as abbreviations.}

\item{drgunit}{Unit of the drug being extracted, e.g., 'mg'}

\item{windowlength}{Length of the search window (in characters) around the drug name in
which to search for dosing entities}

\item{max_edit_dist}{Maximum edit distance allowed when attempting to extract \code{drugnames}.
Allows for capturing misspelled drug name information.}

\item{...}{Additional arguments to \code{\link[medExtractR]{medExtractR}}, for example
\code{lastdose=TRUE} to extract time of last dose (see \pkg{medExtractR} package documentation for details)}
}
\value{
A data.frame with the extracted dosing information, labeled with file name as an identifier \cr
Sample output:\cr
\tabular{rrrr}{
filename \tab entity    \tab  expr   \tab    pos\cr
note_file1.txt \tab DoseChange\tab  decrease \tab  66:74\cr
note_file1.txt \tab DrugName   \tab Prograf \tab   78:85\cr
note_file1.txt \tab Strength  \tab  2 mg   \tab    86:90\cr
note_file1.txt \tab DoseAmt   \tab  1     \tab     91:92\cr
note_file1.txt \tab Frequency \tab  bid    \tab    101:104\cr
note_file1.txt \tab LastDose  \tab  2100    \tab   121:125\cr
}
}
\description{
This function is an interface to the \code{\link[medExtractR]{medExtractR}} function
within the \pkg{medExtractR} package, and allows drug dosing information to be extracted
from free-text sources, e.g., clinical notes.
}
\details{
Medication information, including dosing data, is often stored in free-text sources such as
clinical notes. The \code{extractMed} function serves as a convenient wrapper for the
\pkg{medExtractR} package, a natural language processing system written in R for extracting
medication data. Within \code{extractMed}, the \code{\link[medExtractR]{medExtractR}} function
identifies dosing data for drug(s) of interest, specified by the \code{drugnames} argument,
using rule-based and dictionary-based approaches. Relevant dosing entities include medication
strength (identified using the \code{unit} argument), dose amount, dose given intake, intake
time or frequency of dose, dose change keywords (e.g., 'increase' or 'decrease'), and time of
last dose. After applying \code{\link[medExtractR]{medExtractR}}
to extract drug dosing information, \code{extractMed} appends the file name to results to ensure
they are appropriately labeled. 

See EHR Vignette for for Extract-Med and Pro-Med-NLP. For more details, see Weeks, et al. 2020.
}
\examples{
\donttest{
tac_fn <- list(system.file("examples", "tacpid1_2008-06-26_note1_1.txt", package = "EHR"),
               system.file("examples", "tacpid1_2008-06-26_note2_1.txt", package = "EHR"),
               system.file("examples", "tacpid1_2008-12-16_note3_1.txt", package = "EHR"))

extractMed(tac_fn,
           drugnames = c("tacrolimus", "prograf", "tac", "tacro", "fk", "fk506"),
           drgunit = "mg",
           windowlength = 60,
           max_edit_dist = 2,
           lastdose=TRUE)
}
}
